y5.require(['Utils', 'Elements', 'Dom', 'Classes', 'Events', 'ObjectMove', 'Template', 'Widget'], function() {

var VOID = y5.VOID,
    UNDEF = y5.UNDEF,
    Types = y5.Types,
    Dom = y5.Dom,
    Utils = y5.Utils,
    Classes = y5.Classes,
    Elements = y5.Elements,
    Widget = y5.Widget,
    WidgetWindowName = 'Widget.Window',
    AEventListener = y5.AEventListener,
    fakeIFrameHTML = '<div class="y5-w-fakeframe"><iframe src="'+"javascript:'<body style=\\'background:none\\'>'"+'" frameborder="0"></iframe></div>';

/**
 * Widget.Window
 */
Widget.Window = function(element, content, params) {
    this.init(element, content, params);
};

Widget.Window.prototype = {
    classContainer: 'y5-w-content',

    /**
     * Опции по умолчанию
     */
    defaultParams: {
        // текстовое содержимое диалога
        text: null,

        // модальность
        modal: false,

        // позиционирование по координатам события
        event: null,

        // элемент относительно которого идет позиционирование
        // по умолчанию - видимая область
        element: 'y5:viewport',

        // по горизонтали
        halign: 'center',

        // по вертикали
        valign: 'middle',

        // позиционирование относительно элемента (учитывая его размеры)
        // имеет влияние, когда позиционирование указывается в % (10%, center, middle, etc.)
        relative: false,

        // фиксированная позиция
        fixed: false,

        // сохранять состояние содержимого окна
        saveState: false,

        // восстанавливать позицию окна при следующем открытии
        savePosition: false,

        // имя класса
        className: null,

        // шаблон
        template: 'default'
    },

    toString: function() {
        return WidgetWindowName;
    },

    /*
        Init
    */
    init: function(element, content, params) {
        this.element = element;
        this.content = content;
        this.params = {};
        this.window = null;
        this.events = {};
        this.callbacks = {};
        this.shortcuts = {};
        this.isActive = false;

        // инициализация контейнеров окон
        WindowView.init();

        this.initParams = Utils.objectCopy(params);

        this.makeParams(params);
        this.create();
        this.make(params);
    },

    initOnce: function() {
        this.event('init');
        this.initOnce = VOID;
    },

    box: function(params) {
        var template = y5.Widget.Templates.get(this.toString(), this.params.template);
        return y5.T(template.getHTML(), params);
    },

    create: function() {
        var params = this.params;

        var className = 'y5-w-window' +
            (this.className ? ' ' + this.className : '') +
            (params.className ? ' ' + params.className : '') +
            (params.modal ? ' y5-w-window-modal' : '')
        ;
        this.window = Elements.create('div', {style: 'position:absolute;left:-999em;', 'class': className});
        this.window.innerHTML = this.box();

        this.dragWindowInitOnce();
    },

    getContainerOnce: function() {
        this.container = Dom.getElementByClass(this.classContainer, this.window);

        this.getContainerOnce = VOID;
    },

    getFooterOnce: function () {
        this.footer = Dom.getElementByClass('y5-w-buttons', this.window);

        this.getFooterOnce = VOID;
    },

    fillContainer: function(node) {
        this.container.appendChild(this.params.saveState ? node : node.cloneNode(true));
    },

    refreshContent: function() {
        if (this.params.text) {
            this.container.innerHTML = y5.Strings.text2html(this.params.text);
        } else if (this.params.html) {
            this.container.innerHTML = this.params.html;
        } else {
            Dom.clearNode(this.container);
            this.content.forEach(this.fillContainer, this);
        }
    },

    setContent: function() {
        this.getContainerOnce();

        try {
            this.refreshContent();
        } catch (e) {
            y5.Console.error('Find container', [WidgetWindowName]);
        }
    },

    convertPosition: function(value, element, element_size, window_size) {
        var px = 0;

        if (value.indexOf('%') != -1) {
            px += (element_size - window_size) * (parseFloat(value) / 100);
        } else if (value.indexOf('em') != -1) {
            px += Dom.em2px(parseFloat(value), element);
        } else {
            px += parseFloat(value);
        }

        return parseInt(px, 10);
    },

    getScrollX: function() {
        return (this.params.fixed ? Dom.getPageScrollX() : 0);
    },

    getScrollY: function() {
        return (this.params.fixed ? Dom.getPageScrollY() : 0);
    },

    getPosition: function() {
        var opt = this.params;

        // Элемент, относительно которого вычисляются размеры
        var element;

        // Размеры элемента, относительно кторого будет позиционирования
        var width, height;

        // Если элемент html или body == y5:viewport, то получаем размеры внутренней области окна
        if (opt.element == 'y5:viewport' || Dom.testTagName(opt.element, ['html', 'body'])) {
            element = Dom.getBody();

            var viewport = Dom.viewPort();
            width = viewport[0];
            height = viewport[1];
        } else {
            element = opt.element;

            width = element.clientWidth  || element.offsetWidth;
            height = element.clientHeight || element.offsetHeight;
        }

        var pos = Dom.getOffset(element);

        pos[0] += this.convertPosition(
            opt.halign,
            element,
            width,
            (opt.relative ? this.window.clientWidth : 0)
        );
        pos[1] += this.convertPosition(
            opt.valign,
            element,
            height,
            (opt.relative ? this.window.clientHeight : 0)
        );

        return pos;
    },

    // Инициализация перемещения
    dragWindowInitOnce: function() {
        this.caption = Dom.getElementByClass('y5-w-titlebar', this.window);

        if (this.caption) {
            var _this = this;
            var winXY;

            function down() {
                winXY = Dom.getOffset(_this.window);
            }

            function move(obj, e, newXY, startXY) {
                newXY = [newXY[0] + (winXY[0] - startXY[0]), newXY[1] + (winXY[1] - startXY[1])];
                _this.dragWindowMove(e, newXY);
            }

            function start() {
                _this.dragWindowStart();
            }

            function up() {
                _this.dragWindowUp();
            }

            var objectmove = new y5.ObjectMove(this.caption, document, {down: down, start: start, move: move, up: up});
            objectmove.disableEvents = objectmove.enableEvents = y5.VOID;
        }

        this.dragWindowInitOnce = VOID;
    },

    dragWindowStart: function() {
        Classes.add(this.window, 'y5-w-window-moved');
    },

    dragWindowUp: function() {
        Classes.remove(this.window, 'y5-w-window-moved');
    },

    dragWindowMove: function(e, newXY) {
        // Ограничиваем перемещение окна слева/верх
        if (e.clientX < 0) {
            newXY[0] -= e.clientX;
        }

        if (e.clientY < 0) {
            newXY[1] -= e.clientY;
        }

        var viewport = Dom.viewPort();

        // разность расстояния от курсора до края видимой области
        var dX = e.clientX - viewport[0];
        if (dX > 0) {
            newXY[0] -= dX;
        }

        var dY = e.clientY - viewport[1];
        if (dY > 0) {
            newXY[1] -= dY;
        }
        this.moveTo(this.getMoveTo(this.X = newXY[0], this.Y = newXY[1]));
    },

    // Начальная позиция окна
    initPosition: function() {
        var pos = this.getMoveTo(this.X, this.Y);

        // Новая позиция окна
        var X = pos[0];
        var Y = pos[1];

        // Новая позиция, куда делаем скролл.
        // Сдвигаем на 7% левее и выше позиции окна, чтобы окно не примыкало
        // вплотную к границам окна
        var viewport = Dom.viewPort();
        var newX = Math.floor(X - viewport[0] * 0.07);
        var newY = Math.floor(Y - viewport[1] * 0.07);

        // Получаем текущие позиции скролла окна
        var scrollX = Dom.getPageScrollX();
        var scrollY = Dom.getPageScrollY();

        // Проверяем, если позиция окна левее или выше,
        // до делаем скролл на новую позицию
        if (X < scrollX || Y < scrollY) {
            window.scrollTo(newX, newY);
        }

        this.moveTo(pos, true);
    },

    setPosition: function() {
        this.moveTo(this.getMoveTo(this.X, this.Y), true);
    },

    getMoveTo: function(x, y) {
        var opt = this.params;

        if (typeof x != UNDEF && typeof y != UNDEF) {
            // make some
        } else {
            if (opt.event) {
                x = opt.event.pageX;
                y = opt.event.pageY;
            } else {
                var pos = this.getPosition();
                x = pos[0];
                y = pos[1];
            }
        }

        return [x, y];
    },

    moveTo: function(pos, scroll) {
        var left = (pos[0] + (scroll ? this.getScrollX() : 0));
        var top = (pos[1] + (scroll ? this.getScrollY() : 0));

        this.window.style.left = left + 'px';
        this.window.style.top = top + 'px';
    },

    setZIndex: function(zIndex) {
        this.window.style.zIndex = zIndex;
    },

    /*
        Events
    */
    setEventsOnce: function() {
        // если окно зафиксирован относительно окна браузера, то перепозиционируем
        // его при скролле и изменении размеров окна
        //if (this.params.fixed) {
            this.events.scroll = new AEventListener('scroll', this.setPosition, window, false, this);
        //}
        this.events.resize = new AEventListener('resize', this.setPosition, window, false, this);

        this.setEventsOnce = VOID;
    },

    enableEvents: function() {
        this.setEventsOnce();

        for (var i in this.events) {
            this.events[i].add();
        }
    },

    disableEvents: function() {
        for (var i in this.events) {
            this.events[i].remove();
        }
    },

    event: function(type) {
        var params = this.params,
            name = 'on' + type,
            callbackContext = params.callbackContext || this,
            callbackObject = params.callbackObject;

        // выполняем функцию, если задана в параметрах
        if (Types.func(params[name])) {
            params[name].call(callbackContext, this);
        }

        // выполняем функцию объекта содержащего функции callback
        if (callbackObject && Types.func(callbackObject[name])) {
            callbackObject[name](this);
        }

        return y5.Notify('y5:' + type, this.element, this);
    },

    action: function(e, type) {
        e.preventDefault();
        if (this.event(type)) {
            this.kill();
        }
    },

    /*
        Callbacks
    */
    setCallBacksOnce: function() {
        this.callbacks.killAllWidgets = new y5.Observer('y5:killAllWindows', this.kill, Widget, true, this);

        this.setCallBacksOnce = VOID;
    },

    enableCallBacks: function() {
        this.setCallBacksOnce();

        for (var i in this.callbacks) {
            this.callbacks[i].add();
        }
    },

    disableCallBacks: function() {
        for (var i in this.callbacks) {
            this.callbacks[i].remove();
        }
    },

    /*
        Shortcuts
    */
    setShortcutsOnce: function() {
        this.setShortcutsOnce = VOID;
    },

    enableShortcuts: function() {
        this.setShortcutsOnce();

        for (var i in this.shortcuts) {
            this.shortcuts[i].add();
        }
    },

    disableShortcuts: function() {
        for (var i in this.shortcuts) {
            this.shortcuts[i].remove();
        }
    },

    /*
        Params
    */
    makeParams: function(params) {
        var context;
        if (params) {
            // получаем ссылку на контекст выполнения обработчиков для того, чтобы не копировать его через objectCopy
            context = params.callbackContext;
            params.callbackContext = null;
        }

        // параметры
        this.params = Utils.objectCopy({}, this.defaultParams);
        this.params = Utils.objectCopy(this.params, params);

        if (Types.object(context)) {
            this.params.callbackContext = context;
            params.callbackContext = context;
        }

        // нормализация параметров
        this.normalizeParams();
    },

    normalizeParams: function() {
        var opt = this.params;

        switch (opt.halign) {
            case 'left':
                opt.halign = '0';
                break;

            case 'center':
                opt.halign = '50%';
                break;

            case 'right':
                opt.halign = '100%';
                break;

            default:
                opt.halign = opt.halign.toString();
                break;
        }

        switch (opt.valign) {
            case 'top':
                opt.valign = '0';
                break;

            case 'middle':
                opt.valign = '50%';
                break;

            case 'bottom':
                opt.valign = '100%';
                break;

            default:
                opt.valign = opt.valign.toString();
                break;
        }
    },

    /*
        Base
    */
    make: function(params) {
        if (!this.isActive) {
            this.makeParams(params);
            this.setContent();
            this.getFooterOnce();

            WindowView.show(this, this.params.modal);
            this.initPosition();
            Classes.add(this.window, 'y5-w-visible');

            this.enableEvents();
            this.enableShortcuts();
            this.enableCallBacks();

            this.initOnce();

            this.isActive = true;
            this.event('make');
        }
        this.event('activate');
    },

    kill: function() {
        Classes.remove(this.window, 'y5-w-visible');
        WindowView.hide(this, this.params.modal);

        this.disableEvents();
        this.disableShortcuts();
        this.disableCallBacks();

        this.isActive = false;
        this.event('kill');

        if (!this.params.savePosition) {
            delete this.X;
            delete this.Y;
        }
    },

    cleanup: function() {
        this.kill();

        this.element = null;
        this.content = null;
        this.window = null;
        this.events = null;
        this.callbacks = null;
        this.shortcuts = null;
    }
};

// gecko fix
if (y5.is_gecko && y5.gecko_ver < 1.9) {
    var WindowProto = Widget.Window.prototype;

    WindowProto.createOld = WindowProto.create;
    WindowProto.create = function() {
        this.createOld();
        this.window.style.cssText = 'position:fixed';
    };

    WindowProto.getScrollX = function() {
        return (this.params.fixed ? 0 : -Dom.getPageScrollX());
    };

    WindowProto.getScrollY = function() {
        return (this.params.fixed ? 0 : -Dom.getPageScrollY());
    };

}

var WindowView = {
    // контейнер для показываемых диалогов
    containerView: null,

    // модальный слой под виджетами
    modalLayer: null,

    // список открытых окон
    opens: [],

    init: function() {
        this.initOnce();
    },

    initOnce: function() {
        this.html = Dom.getHtml();
        this.body = Dom.getBody();
        this.box = y5.$('y5-w-window-box') || this.body;

        this.containerView = Elements.create('div', {'class': 'y5-w-window-view', 'style': 'visibility:visible; position:absolute; left:0; top:0; width:100%; height:0; z-index:999999'});
        this.box.insertBefore(this.containerView, this.box.firstChild);

        this.initOnce = VOID;
    },

    showBase: function(widget, modal) {
        if (modal) {
            this.createModalLayerOnce(widget, modal);
            this.containerView.appendChild(this.modalLayer);
            this.modalLayer.style.display = '';
        }
    },

    show: function(widget, modal) {
        widget.window.style.display = '';
        this.showBase(widget, modal);
        this.addOpen(widget);
        this.containerView.appendChild(widget.window);
    },

    hideBase: function() {
        for (var i = this.opens.length - 1; i > -1; i--) {
            if (this.opens[i].params.modal) {
                this.containerView.insertBefore(this.modalLayer, this.opens[i].window);
                return;
            }
        }
        if (this.modalLayer) {
            this.modalLayer.style.display = 'none';
        }
    },

    hide: function(widget) {
        widget.window.style.left = '-999em';
        this.removeOpen(widget);
        this.hideBase(widget);
    },

    createModalLayerElement: function(cssText) {
        var cssClass = (y5.is_opera && y5.opera_ver < 9) ? 'y5-w-modal-opera' : 'y5-w-modal';
        this.modalLayer = Elements.create('div', {'class': cssClass, 'style': cssText});
        new AEventListener('click', function(e) { e.stopPropagation(); }, this.modalLayer, true);

        if (y5.is_ie7down || (y5.is_linux && y5.is_gecko)) {
            this.modalLayer.appendChild(Elements.create(fakeIFrameHTML));
        }
        
        this.containerView.appendChild(this.modalLayer);
    },

    createModalLayerOnce: function() {
        this.createModalLayerElement('position:fixed; display:none; left:0; top:0; width:100%; height:100%');
        this.createModalLayerOnce = VOID;
    },

    addOpen: function(widget) {
        var zIndex = 0;

        this.opens.forEach(
            function(widget) {
                widget.setZIndex(zIndex++);
                widget.disableShortcuts();
            }
        );

        this.opens.push(widget);

        if (widget.params.modal) {
            this.modalLayer.style.zIndex = zIndex++;
        }

        widget.setZIndex(zIndex);
    },

    removeOpen: function(widget) {
        var opens = this.opens;

        // remove widget from opens
        var item = opens.lastIndexOf(widget);
        opens.splice(item, 1);

        // add esc shortcut for last opened widget
        var len = opens.length;
        if (len) {
            opens[len - 1].enableShortcuts();
        }

        var zIndex = 0;
        opens.forEach(
            function(widget) {
                widget.setZIndex(zIndex++);
            }
        );

        if (widget.params.modal) {
            var find = false;
            for (var i = opens.length - 1; i >= 0; i--) {
                if (opens[i].params.modal) {
                    opens[i].setZIndex(i + 1);
                    this.modalLayer.style.zIndex = i;
                    find = true;
                    break;
                }
            }
            if (!find) {
                this.modalLayer.style.zIndex = -1;
            }
        }
    }
};

// для IE:
// для модального диалога подкладываем прозрачный фрейм размерами с body, чтобы перекрыть все select'ы, и див для затененности
// для немодального диалога подкладываем прозрачный фрейм размерами с диалог, чтобы перекрыть select'ы под ним
if (y5.is_ie) {
    WindowView.createModalLayerOnce = function() {
        this.createModalLayerElement('position:absolute; display:none');
        this.createModalLayerOnce = VOID;
    };
}

if (!Widget.Templates.get(WidgetWindowName, 'default')) {
    var template = new Widget.Template(WidgetWindowName, null, 'default');
    template.loadCSSModule(WidgetWindowName);
    var frameHTML = '<div class="y5-w-frame">' +
                        '${content}' +
                    '</div>';

    if (!y5.is_opera || y5.opera_ver >= 9) {
        frameHTML += '<div class="y5-w-shadow"></div>' +
                     '<div class="y5-w-shadow y5-w-shadow2"></div>';
    }

    // для ie и ff под linux подкладываем iframe для перекрытия select и flash
    if (y5.is_ie7down || (y5.is_linux && y5.is_gecko)) {
        frameHTML += fakeIFrameHTML;
    }

    template.setFrame(frameHTML);
    template.setBody(
        '<div class="y5-w-content"></div>'
    );
}

y5.loaded('Widget.Window');

});
