// -*- coding: utf-8; -*-
// цвета подкраски невалидных цен
var bgcolor_warn = '#ffc5c5';
var bgcolor_big = '#ffdfdf';
var bgcolor_ok = '';
var sum_rest, day_budget, spent_today; // defined in main file
var strategy = { name: '', search: { name: 'default' }, net: { name: 'default' } }; // настоящее значение приходит из какого-нибудь главного файла: campaigninfo.html, edit_banner_price, campaign_price_multiedit...

// Облагородить цену и вернуть её
function NormPrice(el, notFormatPrice) {
    var price = common.number.clear(el.value);
    if (notFormatPrice) { return price; }
    var color;
    if (el.value == '' || isNaN(price)) {
        color = bgcolor_warn;
        price = null;
    } else if (price < get_currency(campCurrency).MIN_PRICE) {
        color = bgcolor_warn;
    } else {
        color = price > get_currency(campCurrency).MIN_PAY ? bgcolor_big : bgcolor_ok;
    }
    el.style.backgroundColor = color;
    el.value = common.number.roundFormated(price);
    return price;
}



// Проверить цены
function CheckPricesForm(notFormatPrice) {
    if (submit_flag)
        return false;

    var sf = document.forms[broker_frm];
    var els = sf.elements;
    var l = els.length;
    // Находим количество ставок больше $10
    var warn_num = 0;
    for (var i = 0; i < l; i++) {
        // пропускает отключенные за плохой CTR
        if (els[i].type.toLowerCase() == 'hidden') continue;
        // фильтруем только цены
        if (!els[i].name.match(/^(ctx_val|val)[\d\-\_]+$/)) continue;
        var suffix = els[i].name.replace(/^(ctx_val|val)(.*)/, "$2");
        var price = NormPrice(els[i], notFormatPrice);

        if (price == null) {
            els[i].focus();
            alert(iget('Ставка должна быть числом'));
            return false;
        } else if (price < get_currency(campCurrency).MIN_PRICE) {
            els[i].focus();
            alert(iget('Ставка должна быть не меньше %s', format_const(campCurrency, 'MIN_PRICE')));
            return false;
        } else if (price > get_currency(campCurrency).MAX_PRICE) {
            els[i].focus();
            alert(iget('Ставка должна быть не больше %s', format_const(campCurrency, 'MAX_PRICE')));
            return false;
        } else if (price > get_currency(campCurrency).MIN_PAY) {
            warn_num++;
        }
    }


    // Формируем список предупреждений
    var messages = new Array();
    if (warn_num > 0) {
        var text = '',
            minPayTxt = format_const(campCurrency, 'MIN_PAY');

        if (warn_num % 100 >= 10 && warn_num % 100 <= 20
                || warn_num % 10 >= 5
                ) {
            text = iget('Вами установлено %s ставок больше %s', warn_num, minPayTxt);
        } else if (warn_num % 10 == 1) {
            text = iget('Вами установлена %s ставка больше %s', warn_num, minPayTxt);
        } else {
            text = iget('Вами установлены %s ставки больше %s', warn_num, minPayTxt);
        }
        messages[messages.length] = text;
    }

    // выводим запрос на подтверждение
    if (messages.length > 0) {
        var text = '';
        if (messages.length == 1) {
            text = messages[0] + "\n";
        } else {
            for (var i = 0; i < messages.length; i++) {
                text += (i + 1) + ". " + messages[i] + "\n";
            }
        }
        submit_flag = false;
        return confirm(iget('Внимание!') + '\n\n' + text + '\n' + iget('Вы уверены, что хотите сохранить?'));
    } else {
        submit_flag = true;
        return true;
    }
}

