/* Календарь */

/* Пример использования:

    <form>
    <script>
        var cFrom = new clite('2004-03-09');
        cFrom.addField('from', '%Y-%M-%D 00:00:00');
        cFrom.write();
    </script>
    <br/>
    <script>
        var cTo = new clite(); // даты не выбрана
        cTo.addField('to-year', '%Y');
        cTo.addField('to-month', '%M');
        cTo.addField('to-day', '%D');
        cTo.write();
    </script>

    <input type="submit"/>
    </form>

    Метод addField добавляет поле с заданным именем и нужным форматом даты.
    Пока что есть %Y, %M, %D.
    При необходимости можно добавить новые "теги" в метод format.

    Дата принимается в формате YYYY-MM-DD, можно изменить в функции string2date.

*/

// ------------------------------------------------------------------------------------------------

var mShort = [iget('янв'), iget('фев'), iget('мар'), iget('апр'), iget('мая'), iget('июн'), iget('июл'), iget('авг'), iget('сен'), iget('окт'), iget('ноя'), iget('дек')],
    mLong = [iget('Январь'), iget('Февраль'), iget('Март'), iget('Апрель'), iget('Май'), iget('Июнь'), iget('Июль'), iget('Август'), iget('Сентябрь'), iget('Октябрь'), iget('Ноябрь'), iget('Декабрь')],
    wShort = [iget('Пн'), iget('Вт'), iget('Ср'), iget('Чт'), iget('Пт'), iget('Сб'), iget('Вс')],
    currentId = -1;

// ------------------------------------------------------------------------------------------------

/*
    id-шники:

    calDiv - div, в котором отображается календарь

    calObj4462 - object
    calInput4462 - input
    calButton4462 - button
*/

// clite.calendar()
function clite(string, href, options) {
    if (!options) options = {};

    // Верхний и нижний пределы
    if (!options.limits) {
        options.limits = {
            minDate: undefined,
            maxDate: undefined
        };
    }

    if (options.limits.minDate instanceof Date) {
        options.limits.minDate.setMinutes(0);
        options.limits.minDate.setHours(0);
        options.limits.minDate.setSeconds(0);
    }

    if (options.limits.maxDate instanceof Date) {
        options.limits.maxDate.setMinutes(59);
        options.limits.maxDate.setHours(23);
        options.limits.maxDate.setSeconds(59);
    }

    this.date = string2date(string);
    this.limits = options.limits;

    if (this.date) {
        // Проверка периода на "пробивание" нижнего или верхнего предела
        // Если да, заменить на допустимую дату
        if (this.date < this.limits.minDate) {
            this.date = new Date(this.limits.minDate);
        } else if (this.date > this.limits.maxDate) {
            this.date = new Date(this.limits.maxDate);
        }
        this.showDate = new Date(this.date.getTime());
    } else { 
        this.showDate = new Date();
    }

    this.showDate.setDate(15);
	this.showDate.setHours(3);

    if(typeof(href) == 'undefined') {
	    href = {};
    }
    this.param = href;
    if (!this.date) {
        this.date = new Date();
        this.empty = true;
        // если empty = true, то поле с датой пустое и ничего не сабмитится
    }

    this.fields = new Object;
    this.rnd = Math.floor(Math.random() * 1000000);
    window['calObj' + this.rnd] = this;

    // methods
    this.toString = date2string;
    this.addField = addField;
    this.format = format;
    this.appendToPlace = appendToPlace;
    this.input_html = input_html;
    this.input_html_init = input_html_init;
    this.write = write;
    this.update = update;
    this.html = html;
    this.update_date = update_date;
    this.setPrevCal = set_prev_cal;
    this.setNextCal = set_next_cal;
    

    var div = document.getElementById('calDiv');
    if (!div) {
        div = document.createElement('div');
        div.id = 'calDiv';
        div.className = 'calendar-div';
        var body = document.body;
        body.insertBefore(div, body.firstChild);

        addEvent(div, 'click', calClick);
    }

    this.div = div;
}

// ------------------------------------------------------------------------------------------------

// clite.write()
function input_html() {
    var fields = this.fields;
    var html = '<input class="calendar-input" id="calInput' + this.rnd + '" value="' + this.toString() + '" readonly="yes">&nbsp;';
    html += '<span class="b-form-button b-form-button_valign_middle b-form-button_height_22 b-form-button_theme_grey-no-transparent-22 calendar-form"><i class="b-form-button__left"></i><span class="b-form-button__content calendar-button__content"><span class="b-form-button__text"><span class="calendar-content">&nbsp;</span></span></span><input class="calendar-button b-form-button__input" id="calButton' + this.rnd + '" tabindex="1" type="button" value=" " onclick="showCalendar(this, ' + this.rnd + ')"></span>';
    for (field in fields) {
        html += '<input class="calendar-' + field + '" name="' + field + '" id="' + field + '" type="hidden" value="' + this.format(fields[field]) + '">';
    }
    return html;
}
function input_html_init() {
    this.update();
    var button = document.getElementById('calButton' + this.rnd);
    addEvent(button, 'click', calClick);
}

function appendToPlace(parent) {
    this.parent = parent;
    parent.innerHTML = this.input_html();
    
    this.input_html_init();
}

function write() {
    document.write(this.input_html());
    this.input_html_init();
}

function update_date(string) {
    this.date = string2date(string);
    if (!this.date) {
        this.date = new Date();
        this.empty = true;
        // если empty = true, то поле с датой пустое и ничего не сабмитится
    }
    this.update();
}

// clite.update()
function update() {
    this.div.innerHTML = this.html();
    var fields = this.fields;
    var myvar;
    for (field in fields) {
        myvar = this.format(fields[field]);
        document.getElementById(field).value = myvar;
    }
    document.getElementById('calInput' + this.rnd).value = this.toString();
    if (jQuery) {
        var input = $(this.parent).find('.calendar-input');
        input.change();
    }
}

// clite.toString()
function date2string() {
    if (this.empty) {
        return '';
    }

    var date = this.date;
    return zeroFill(date.getDate()) + ' ' + iget(mShort[date.getMonth()]) + ' ' + date.getFullYear();
}

// clite.addField()
function addField(name, format) {
    this.fields[name] = format;
}

//clite.format()
function format(f) {
    if (this.empty) {
        return '';
    }

    var fY = this.date.getFullYear();
    f = f.replace(/%Y/g, fY)
        .replace(/%M/g, zeroFill(this.date.getMonth() + 1))
        .replace(/%m/g, zeroFill(this.date.getMonth() + 1))
        .replace(/%D/g, zeroFill(this.date.getDate()))
        .replace(/%d/g, zeroFill(this.date.getDate()))
        .replace(/%y/g, zeroFill(fY % 100));

    return f;
}

// ------------------------------------------------------------------------------------------------

function repos(o) {
    var style = document.getElementById('calDiv').style,
        pos = getPosition(o);

    style.left = pos.x + 'px';
    style.top = pos.y + 'px';
}

function show() {
    var cal = document.getElementById('calDiv');
    if (cal) {
        //		hide_selects('show');
        cal.style.visibility = 'visible';
    }
}

function hide() {
    var cal = document.getElementById('calDiv');
    if (cal) {
        cal.style.visibility = 'hidden';
        //		hide_selects('hide');
        closeCalendarTimeOut = 0;
    }
}

function visible() {
    var cal = document.getElementById('calDiv');
    if (cal) {
        return (cal.style.visibility == 'visible');
    }
    return false;
}

function string2date(string) {
    var re = /(\d+)-(\d+)-(\d+)/,
        date = re.exec(string);
    if (date) {
        return new Date(date[1], date[2] - 1, date[3]);
    }
}

function zeroFill(value) {
    return (value < 10 ? '0' : '') + value;
}

function hide_selects(mode) {
    var selects = document.getElementsByTagName('select');
    for (var i = 0; i < selects.length; i++) {
        selects[i].style.visibility = (mode == 'show') ? 'hidden' : 'visible';
    }
}

// ------------------------------------------------------------------------------------------------

function showCalendar(o, id) {
    repos(o);

    var cal = window['calObj' + id];
	cal.showDate = new Date(cal.date.getTime());
	cal.showDate.setDate(15);
	cal.showDate.setHours(3);
    cal.update();
    cal.oldDate = cal.date;

    if (id == currentId && visible()) {
        currentId = -1;
        hide();
    } else {
        currentId = id;
        show();
    }
}

function calSetDate(id, i) {
    var cal = window['calObj' + id];
	cal.date = new Date(cal.showDate.getTime());
    cal.date.setDate(i);
    hide();
    cal.empty = false;
    cal.update();
}

function calSetMonth(id, i) {
    var cal = window['calObj' + id];
    cal.showDate.setMonth(i + cal.showDate.getMonth());
    cal.update();
}

function calSetYear(id, i) {
    var cal = window['calObj' + id];	
    cal.showDate.setYear(i + cal.showDate.getFullYear());
    cal.update();
}

function calSetToday(id) {
    var cal = window['calObj' + id];
    cal.showDate = new Date();
	cal.date = new Date(cal.showDate.getTime());
	cal.showDate.setDate(15);
	cal.showDate.setHours(3);	
    hide();
    cal.empty = false;
    cal.update();
}

function calClear(id) {
    var cal = window['calObj' + id];
    cal.showDate = new Date();
	cal.date = new Date(cal.showDate.getTime());
	cal.showDate.setDate(15);
	cal.showDate.setHours(3);	
    hide();
    cal.empty = true;
    cal.update();
}

function calDayOver(o) {
    o.oldClassName = o.className;
    o.className = o.className + ' over';
}

function calDayOut(o) {
    o.className = o.oldClassName;
}

// ------------------------------------------------------------------------------------------------

function getPosition(o) {
    var x = o.offsetLeft;
    var y = o.offsetTop + o.offsetHeight;
    // + 1
    while (o.offsetParent != null) {
        o = o.offsetParent;
        x += o.offsetLeft;
        y += o.offsetTop;
    }

    return {x: x, y: y};
}

// ------------------------------------------------------------------------------------------------

function set_prev_cal(tcal) {
    this.prevCal = tcal;
}
// ------------------------------------------------------------------------------------------------
function set_next_cal(tcal) {
    this.nextCal = tcal;
}

// ------------------------------------------------------------------------------------------------

function calMonthOver(id) {
    for(var i = 1; i < 32; i++)
    {
        var did = 'cal_' + id + '_date_' + i + '_div';        
        var d = document.getElementById(did);                
        if(d){            
            d.oldClassName = d.className;
            d.className = d.className + ' over';
        }  else {
            break;
        }  
    }
}

function calMonthOut(id) {
    for(var i = 1; i < 32; i++) {
        var did = 'cal_' + id + '_date_' + i + '_div',
            d = document.getElementById(did);
        if (d) {
            d.className = d.oldClassName;
        } else {
            break;
        }  
    }    
}

// ------------------------------------------------------------------------------------------------

function calSelectMonth(id, mnth) {
    var cal = window['calObj' + id];
    
    if (cal.nextCal) {
        calSetDate(id, 1);
        cal.nextCal.date = new Date(cal.date);
        cal.nextCal.date.setMonth(cal.nextCal.date.getMonth() + 1);
        cal.nextCal.date.setDate(0);
        cal.nextCal.update();
    } else if(cal.prevCal) {
        calSetDate(id, 1);
        cal.prevCal.date = new Date(cal.date);        
        cal.prevCal.update();
        cal.date.setMonth(cal.date.getMonth() + 1);
        cal.date.setDate(0);
        cal.update();        
    } 
} 

// ------------------------------------------------------------------------------------------------
function calSetWeek(id, i) {
    var cal = window['calObj' + id];
    if (cal.nextCal) {
        calSetDate(id, i);
        cal.nextCal.date = new Date(cal.date);
		cal.nextCal.showDate = new Date(cal.date);
		calSetDate(cal.nextCal.rnd, cal.date.getDate() + 6);
    } else if(cal.prevCal) {
        calSetDate(id, i + 6);
        cal.prevCal.date = new Date(cal.date);
		cal.prevCal.showDate = new Date(cal.date);
		calSetDate(cal.prevCal.rnd, cal.date.getDate() - 6);
    } 
}

// ------------------------------------------------------------------------------------------------

// clite.html()
function html() {
    var i,
        r = '<iframe frameborder="0"></iframe><table cellpadding="0" cellspacing="0" class="calendar">',
        m = new Date(this.showDate),
        limits = this.limits;

    m.currentYear = m.getFullYear();
    m.currentMonth = m.getMonth();
    m.currentDate = m.getDate();

    r += '<tr class="set-year">';
    var extSet = (this.prevCal || this.nextCal);        
    
    if(extSet){
        r += '<td class="empty">&nbsp;</td>';
    }

    var availYPrevBtn = !limits.minDate || m.currentYear - 1 >= limits.minDate.getFullYear(),
        availYNextBtn = !limits.maxDate || m.currentYear + 1 <= limits.maxDate.getFullYear();

    r += '<td class="prev" ' + (availYPrevBtn && 'onclick="calSetYear(' + this.rnd + ', -1)"') + '>&laquo;</td>';

    r += '<td class="current" colspan="5">' + this.showDate.getFullYear() + '</td>';

    r += '<td class="next" ' + (availYNextBtn && 'onclick="calSetYear(' + this.rnd + ', 1)"') + '>&raquo;</td>';

    r += '<tr class="set-month">';
    if(extSet){
        r += '<td class="empty">&nbsp;</td>';
    }

    var availMPrevBtn = !(
        limits.minDate
        && m.currentYear == limits.minDate.getFullYear()
        && m.currentMonth - 1 < limits.minDate.getMonth()
    );

    var availMNextBtn = !(
        limits.maxDate
        && m.currentYear == limits.maxDate.getFullYear()
        && m.currentMonth + 1 > limits.maxDate.getMonth()
    );

    r += '<td class="prev" ' + (availMPrevBtn && 'onclick="calSetMonth(' + this.rnd + ', -1)"') + '>&laquo;</td>';
    
    if (extSet) {
        r += '<td class="current" colspan="5"><div style="cursor: pointer;" onmouseover="calMonthOver(' + this.rnd + ');" onmouseout="calMonthOut(' + this.rnd + ');" onclick="calSelectMonth(' + this.rnd + ', ' + this.showDate.getMonth() + ')"><img src="/i/monthselect.gif">&nbsp;' + iget(mLong[this.showDate.getMonth()]) + '</div></td>';
    } else {
        r += '<td class="current" colspan="5">' + iget(mLong[this.showDate.getMonth()]) + '</td>';
    }
    
    r += '<td class="next" ' + (availMNextBtn && 'onclick="calSetMonth(' + this.rnd + ', 1)"') + '>&raquo;</td>';

    r += '<tr class="dates-head">';
    if (extSet) {
        r += '<td class="empty">&nbsp;</td>';
    }
    for (i = 0; i < wShort.length; i++) {
        r += '<th class="date">' + iget(wShort[i]) + '</th>';
    }

    var now = new Date(),
		inputDateFullYear = this.date.getFullYear(),
		inputDateMonth = this.date.getMonth(),
		inputDateDay = this.date.getDate(),
        n = 1;

    m.setDate(1);
    var w = m.getDay();
    w = (w == 0) ? 7 : w;
    var trCounter = 1;
    if (w > 1) {
        r += '<tr class="dates" id="calTr' + trCounter + '">';
        if (extSet) {
            r += '<td onclick="calSetWeek(' + this.rnd + ', ' + ((w-2)/-1) + ')" class="date" onmouseover="calDayOver(document.getElementById(\'calTr' + trCounter + '\'))" onmouseout="calDayOut(document.getElementById(\'calTr' + trCounter + '\'))"><img src="/i/weekselect2.gif"></td>';
        }

        trCounter++;
        for (i = 1; i < w; i++) {
            r += '<td class="empty">&nbsp;</td>';
            n++;
        }
    }

    var availDate, // Доступная дата
        tmpDate = new Date(m);

    for (i = 1; i <= 31; i++) {
        m.setDate(i);
        if (m.getMonth() != m.currentMonth) {            
            break;
        }

        if (n % 7 == 1) {
            r += '<tr class="dates" id="calTr' + trCounter + '">';
            if(extSet){
                r += '<td onclick="calSetWeek(' + this.rnd + ', ' + i + ')" class="date" onmouseover="calDayOver(document.getElementById(\'calTr' + trCounter + '\'))" onmouseout="calDayOut(document.getElementById(\'calTr' + trCounter + '\'))"><img src="/i/weekselect2.gif"></td>'; //!!!!!!!!!
            }
            trCounter++;
        }

        tmpDate.setDate(i);

        availDate = (!limits.minDate || limits.minDate <= tmpDate)
            && (!limits.maxDate || tmpDate <= limits.maxDate);

        var className = (i == inputDateDay && m.currentMonth == inputDateMonth && m.currentYear == inputDateFullYear)? "current": "date";
        if (!availDate) className += ' disabled';

        if (extSet) {
            r += ('<td class="' + className + '" id="cal_' + this.rnd + '_date_' + i + '_div" ' + (availDate && 'onclick="calSetDate(' + this.rnd + ', ' + i + ')"') + ' onmouseover="calDayOver(this)" onmouseout="calDayOut(this)">' + i + '</td>');
        } else {
            r += ('<td class="' + className + '" ' + (availDate && 'onclick="calSetDate(' + this.rnd + ', ' + i + ')"') + ' onmouseover="calDayOver(this)" onmouseout="calDayOut(this)">' + i + '</td>');
        }
        
        n++;
    }

    if (n % 7 > 1) {
        for (i = 0; i <= 7 - n % 7; i++) {
            r += '<td class="empty">&nbsp;</td>';
        }
    }

 
    if (this.param  && this.param.no_clear_button) {
        r += '<tr class="set-month">';
        if (extSet) {
            r += '<td class="empty">&nbsp;</td>';
        }
        r += '<td class="clear current" colspan="2">&nbsp;</td>  <td class="set-today" colspan="3" onclick="calSetToday(' + this.rnd + ')">' + iget("Сегодня") + '</a></td><td class="clear current" colspan="2">&nbsp;</td>';
    } else {
        r += '<tr>';
        if(extSet){
            r += '<td class="clear">&nbsp;</td>'; //!!!!!!!!!
        }
        r += '<td class="set-today" colspan="4" onclick="calSetToday(' + this.rnd + ')">' + iget("Сегодня") + '</a></td>';
	    r += '<td class="clear" colspan="3" onclick="calClear(' + this.rnd + ')">' + iget("Очистить") + '</a></td>';
    }
    r += '</tr>';
    r += '</table>';

    return r;
}

// ------------------------------------------------------------------------------------------------

function addEvent(element, event, func) {
    if (element.addEventListener) {
        element.addEventListener(event, func, false);
    } else if (element.attachEvent) {
        element.attachEvent('on' + event, func);
    }
}

function calClick(e) {
    var event = (e) ? e : window.event;
    event.cancelBubble = true;
}

addEvent(window, 'resize', hide);
addEvent(document, 'click', hide);
