/**
 * Created by JetBrains WebStorm.
 * User: collapsus
 * Date: 7/1/11
 * Time: 3:46 PM
 * To change this template use File | Settings | File Templates.
 */

/**
 * Функция возвращает валюту по её коду
 * @param {String} currency код валюты
 * @returns {Object} объект валюты
 */
function get_currency(currency) {
    return window.currencies[currency];
}

/**
 * Функция для вывода определённой суммы денег, в определённой валюте
 * @param {String} currency код валюты
 * @param {Number|String} sum сумма денег
 * @param {Object} [opts] дополнительные параметры форматирования {delim: '&nbsp', nds: 1}
 * @param {String} [opts.delim] разделитель между числом и названием валюты
 * @param {Number|undefined} [opts.nds] указывать ли информацию о НДС
 *     (1 - включая НДС, 0 - без учёта НДС, undefined - ничего не пишем про НДС)
 * @param {undefined|Number} [opts.discount] указывать ли информацию о скидке
 *     (если > 0 - без учёта скидки, undefined - ничего не пишем про скидку)
 *     на самом деле про скидку будем писать только в одном месте, и только про её отсутствие DIRECT-28963
 * @returns {String} сумма денег в валюте
 */
function format_sum_of_money(currency, sum, opts) {
    var delim = opts && opts.delim || ' ';

    return sum + delim + format_currency(currency) +
        (opts && opts.nds !== undefined ?
            delim + (opts.discount === undefined || opts.discount > 0 ?
                opts.nds ? iget('включая НДС') : iget('без учёта НДС') :
                opts.nds ?
                    iget('включая НДС и без учёта скидки') :
                    iget('без учёта НДС и скидки')) :
            '');
}

/**
 * Функция для вывода конкретной константы (например 'наименьшая ставка') в определённой валюте
 * @param {String} currency код валюты
 * @param {String} constName имя константы (например 'MIN_PRICE')
 * @param {Object} [opts] дополнительные параметры форматирования {delim: '&nbsp', nds: 1}
 * @param {String} [opts.delim] разделитель между числом и названием валюты
 * @param {Number|undefined} [opts.nds] указывать ли информацию о НДС
 * (1 - включая НДС, 0 - без учёта НДС, undefined - ничего не пишем про НДС)
 * @returns {String} константа в определённой валюте
 */
function format_const(currency, constName, opts) {
    return format_sum_of_money(currency, get_currency(currency)[constName], opts);
}

/**
 * Функция вывода строки с сокращённым именем валюты, например 'руб.'
 * @param {String} currency код валюты
 * @returns {String} имя валюты
 */
function format_currency(currency) {
    return iget(get_currency(currency).name);
}

/**
 * Округляет ставку в большую/меньшую сторону до шага торгов в указанной валюте
 * @param {Number} price ставка для округления
 * @param {String} currency имя валюты
 * @param {String} roundDirection направление округления ('up' или 'down')
 * @returns {Number}
 */
function round_price_to_currency_step(price, currency, roundDirection) {
    var step = get_currency(currency).AUCTION_STEP,
        priceRoundedDown = Math.floor((price * 1e6) / (step * 1e6) + 1e-6) * step;

    return priceRoundedDown + (roundDirection == 'up' && price > priceRoundedDown ? step : 0);
}

