include('../common.js');

(function(){

    var slice = Array.prototype.slice;

    // Internal function used to implement `throttle` and `debounce`.
    var limit = function(func, wait, debounce) {
        var timeout;
        return function() {
            var context = this, args = arguments;
            var throttler = function() {
                timeout = null;
                func.apply(context, args);
            };
            if (debounce) clearTimeout(timeout);
            if (debounce || !timeout) timeout = setTimeout(throttler, wait);
        };
    };

    common.func = {

        // Delays a function for the given number of milliseconds, and then calls
        // it with the arguments supplied.
        delay: function(func, wait) {
            var args = slice.call(arguments, 2);
            return setTimeout(function(){ return func.apply(func, args); }, wait);
        },

        // Defers a function, scheduling it to run after the current call stack has
        // cleared.
        defer:  function(func) {
            return this.delay.apply(this, [func, 1].concat(slice.call(arguments, 1)));
        },

        // Returns a function, that, when invoked, will only be triggered at most once
        // during a given window of time.
        throttle: function(func, wait) {
            return limit(func, wait, false);
        },

        // Returns a function, that, as long as it continues to be invoked, will not
        // be triggered. The function will be called after it stops being called for
        // N milliseconds.
        debounce: function(func, wait) {
            return limit(func, wait, true);
        }

    }

})();