include('../common.js');

common.inflector = new function() {
    this.pluralForms = function(str) {
        var args = $.makeArray(arguments);
        args.splice(0, 1);

        return str.replace(/{([^}]+)}/g, function(s, $1) {
            return common.inflector.pluralizeWord($1.split('|'), args.shift());
        });
    };

    this.pluralize = function(string, count1 /*, count2, count3 ... */) {
        var args = arguments, count = 0;
        return string.replace(/(\%[df])(([^\{%]*)\{([^\{]+)\})?/, function() {
            count++;
            if (arguments[2]) {
                return args[count] + arguments[3] + common.inflector.pluralizeWord(arguments[4].split('|'), args[arguments[1] == '%f' ? ++count : count]);
            } else {
                return args[count];
            }
        });
    };


    if (window.Direct_lang == 'ru' || window.Direct_lang == 'ua') {
        this.pluralizeWord = function(forms, count) {
            count %= 100;
            if (count >= 5 && count <= 20) {
                return forms[2];
            }
            count %= 10;
            if (count == 1) {
    			return forms[0];
    		} else if (count < 5 && count > 0) {
    			return forms[1];
    		}
    		return forms[2];
    	}
    } else if (window.Direct_lang == 'en' || window.Direct_lang == 'tr') {
        this.pluralizeWord = function(forms, count) {
            if (count == 1) return forms[0];
            return forms[1];
    	}
    }
};

