include('../common.js');

/** 
 * Очень, очень простой асинхронный загрузчик
 */
common.loader = {
    _loaded: {},
    _loading: {},
    _callbacks: [],
    _map: {},
    _queue: [],
    
    load: function(mods, callback) {
        var srcs = []
        for (var i=0; i < mods.length; i++) {
            srcs[i] = this._mapToUrl(mods[i]);
            this._queue.push(srcs[i]);
        };
        this._callbacks.push([srcs, callback]);
        common.loader._notifyCallbacks();
        this._loadNext();
    },
    
    _notifyCallbacks: function() {
        var tmp = [];
        for (var i=0; i < this._callbacks.length; i++) {
            var callback = this._callbacks[i];
            for (var j=0; j < callback[0].length; j++) {
                if (!this._loaded[ callback[0][j] ]) {
                    tmp.push(callback);
                    break;
                }
            };
            if (j == callback[0].length) callback[1] && callback[1]();
        };
        this._callbacks = tmp;
    },
    
    _loadNext: function() {
        var src;
        do { src = this._queue.shift() } while (this._loaded[src]);
        if (!src || this._loading[src]) return;
        this._loading[src] = true;
        this._attach(src);
    },
    
    _attach: function(src) {
        var node = document.createElement("script");
        node.type = "text/javascript";
        node.charset = "utf-8";
        node.setAttribute("async", "async");
        var handler = function(e) {
            e = e || window.event;
            if (e.type === "load" || (/^(complete|loaded)$/).test(node.readyState)) {
                setTimeout(function() {
                    common.loader._loading[src] = undefined;
                    common.loader._loaded[src] = true;
                    node.removeEventListener ? node.removeEventListener("load", handler, false) : node.detachEvent("onreadystatechange", handler);
                    node = handler = null;
                    common.loader._notifyCallbacks();
                    common.loader._loadNext();
                }, 1)
            }
        };

        //Set up load listener.
        node.addEventListener ? node.addEventListener("load", handler, false) : node.attachEvent("onreadystatechange", handler);
        node.src = src; // + '?r' + Math.random();

        return common.loader._head.insertBefore(node, common.loader._head.firstChild);        
    },
    
    _mapToUrl: function(mod) {
        return this._map[mod] || mod;
    }
};

common.loader._head = document.getElementsByTagName('script')[0].parentNode;
