include('observable.js');

common.Model = $.extend({}, common.Observable, new function() {
    this.update = function(values, source) {

        var changes = {}, fields = [];

        for (var i in values) {
            if (!values.hasOwnProperty(i)) continue;

            var isChanged = this.isReallyChanged(i, this[i], values[i]);

            //нужно различать незаданное значение и пришедшую цифру 0, которая может быть валидным значением
            if ((this[i] != values[i] || !values[i] && this[i] !== values[i]) && isChanged) {
                changes[i] = [this[i], values[i]]
                fields.push(i);
                this[i] = values[i];
            }
        }
        this._triggerChange({changes: changes, fields: fields, source: source, model: this});
    };

    /**
     * This method may be overwritten in subclasses if there's a need
     * to check if non-primitive value is really changed.
     *
     * @see `direct.forecast.Model` implementation for instance
     */
    this.isReallyChanged = function(field, currentValue, newValue) {
        return true;
    }

    this._triggerChange = function(e) {
        this.trigger('change', e);
    };
});

common.model = {}; // namespace