include('../model.js');

common.model.BindingMixin = {
    init: function(model, input, name) {
        this.model = model;
        this.input = input;
        this.name  = name;
    },
    
    bindEvents: function() {
        var _this = this;
        this.model.bind('change.' + this.name, function() { _this.modelChanged() });
    },
    
    bindToModel: function() {
        var _this = this;
        this.input.bind('change blur', this.inputChanged, function() { _this.inputChanged() });
    },
    
    modelChanged: function() {
        this.input.val((model[this.name] && model[this.name].apply) ? model[this.name]() : model[this.name]);
    },
    
    inputChanged: function() {
        var data = {};
        data[this.name] = this.input.val();
        this.model.update(data);
    }
}

common.model.Binding = function(model, input, name) {
    this.init(model, input, name)
};

common.model.Binding.prototype = $.extend({}, common.model.BindingMixin);
