/**
 * Внешние утилиты для работы с моделями
 */
common.modelUtils = new function() {

    this.newProp = function(proto, field, setter) {
        return function(value, source) {
            if (value === undefined) return proto['_' + field];
            if (setter) { setter.call(proto, value, source); } else { proto['_' + field] = value };
            return this;
        };
    };

    /*
     * Добавляет модели флаг с заданным именем. Флаг может принимать только значения 0 или 1
     * proto - модель которой добавляется флаг
     */
    this.newFlag = function(proto, field) {
        return this.newProp(proto, field, function(v) {
            this['_' + field] = v * 1 ? 1 : 0;
        });
    };

    /*
     * Добавляет модели поле с заданным именем. Значение поле может быть только строкой
     * proto - модель которой добавляется поле
     */
    this.newField = function(proto, field) {
        return this.newProp(proto, field, function(v) {
            this['_' + field] = v ? v + '' : '';
        });
    };

    this.addFlags = function(proto, flags) {
        for (var i =0, len = flags.length; i<len; i++)
			proto[ flags[i] ] = this.newFlag(proto, flags[i]);
    };

    this.addFields = function(proto, fields) {
        for (var i =0, len = fields.length; i<len; i++)
			proto[ fields[i] ] = this.newField(proto, fields[i]);
    };
};