/*
 *  Обеспечивает старые геттеры и сеттеры модели вида model.prop() и model.prop(value)
 */

common.models.deprecatedFacade = {
    /*
     * Навешивает функции-сеттеры
     * proto - экземпляр модели, на который надо навесить свойства
     * schemes - список правил для этой модели
     */
    set: function (proto, schemes) {

        for (var field in schemes.fields) {
            if (schemes.globalTrigger) {
                if (!proto.triggers) { proto.triggers = []; }
                proto.triggers.push(field);
            }
            proto[ field ] = function(field) {
                return function(value) {
                    return (value === undefined) ? proto.get(field) : proto.set(field, value);
                }
            }(field);
            proto.getData = proto.memento;

            proto.saveState = function() {};
        };

    }
};


