include('abstractModel.js');
include('deprecatedFacade.js');
/*
 * Конктретный экземполяр модели
 */
(function() {
    var self = common.models.modelInstance = function(data, schemes, useDeprecatedFacade) {
        if (!(this instanceof common.models.modelInstance)) {
            return new common.models.modelInstance(data, schemes, useDeprecatedFacade);
        }
        this.init(data, schemes, useDeprecatedFacade);
    };

    self.prototype = $.extend({}, common.models.abstractModel, new function() {
        this.init = function(data, schemes, useDeprecatedFacade) {

            common.models.abstractModel.init.call(this, data, schemes);
            if (useDeprecatedFacade) {
                common.models.deprecatedFacade.set(this, schemes)
            }

        };
    });
})();