include('../common.js');

(function (){

    /*
     * Форматирование числа. Используем только тогда, когда уверены, что number - число
     * Если есть вероятность, что number не число - предварительно используем clear
     */
    common.number = {
        format: function(number, options) {
            options = $.extend({
                //округление
                precision: 2,
                //разделитель разрядов
                exponent_delimiter: ' ',
                //плавающая точка
                float_delimiter: '.',
                //результат, возвращаемый при неудаче
                fail: NaN
            }, options);
            if (isNaN(number)) { return options.fail }
            var replaced = '';
            number = (''+common.number.roundFormated(number, {precision: options.precision})).replace('.', options.float_delimiter);
            while((replaced = number.replace(/(\d)(\d\d\d)($|\D)/, '$1' + options.exponent_delimiter + '$2$3')) != number) number = replaced;
            return number;
        },

        /*
         * Простое округление - возвратит всегда число
         */
        round: function(number, options) {
            options = $.extend({
                precision: 2,
                roundType: 'round',
                fail: NaN
            }, options);
            return roundNumber(number, options);

        },

        /*
         * Округление с форматированием, возвратит строку с заданными параметрами окгруления
         * Например округляя 2 с точностью 4, вернёт строку 2.0000
         */
        roundFormated: function(number, options) {
            options = $.extend({
                precision: 2,
                roundType: 'round',
                fail: NaN
            }, options);
            return roundNumberFormated(number, options);
        },

        /*
         * Положительное целое число
         */
        isInteger: function(number) {
            return !!(number + '').match(/^\s*[0-9]+\s*$/);
        },

        /*
         * Число с плавающей точкой
         */
        isDecimal: function(number) {
             return !!(number + '').match(/^\s*^[0-9]+(\.[0-9]+)?\s*$/);
        },

        clear: function(number, options) {
            options = $.extend({
                fail: number,
                precision: 2
            }, options);

            //заменяем потенциальные варианты точки на точку
            number = (number + '').replace(/[//,.юЮбБ<>]/gi, '.');

            if (!isNaN(number)) { return number; }
            if (!!(number+'').match(/e/)) {
                number = (+number).toFixed(options.precision);
            }

            if (options.mode != 'strict') {
                //удаляем все символы кроме чисел и .
                number = number.replace(/[^0-9.]/g, '');

            } else {
                //чистим только пробелы
                number = number.replace(/(\s|\u00A0)+/g, '');
            }
            number = number.replace(/^\.([^.]+)$/, '0.$1');
            //удаляем первый 0 в числах вида 034 -> 34, если number == '0' пропускаем
            number = number.replace(/^0+(?!\.|$)/g, '');

            if (!number.match(/^[0-9]+((\.)[0-9]+)?$/)) {
                return options.fail;
            }

            return number;
        }

    };

    /*
    * Возвращает округленное число с нужным числом нулей при необходимости
    * Например - 0.1 и precicion = 3 вернет 0.100
    */
    function roundNumberFormated(value, options) {
        options = $.extend({
            precision: 2,
            roundType: 'round',
            fail: NaN
        }, options);

        value = roundNumber(value, options) + '';
        if (options.precision == 0) return value;

        var pos = value.indexOf('.');
        var zerros = 0;
        if (pos == -1) {
            value += '.';
            zerros = options.precision;
        } else {
            zerros = options.precision - (value.length - pos - 1);
        }
        for (var i=0, l = zerros; i < l; i++) {
            value += '0';
        }
        return value;
    }

    /*
     *  возвращает округленное число
     */
    function roundNumber(value, options) {
        options = $.extend({
            precision: 2,
            roundType: 'round',
            fail: NaN
        }, options);

        if (isNaN(value)) {
            return options.fail;
        }

        var pow = Math.pow(10, options.precision);

        value =  Math[$.inArray( options.roundType, ['round', 'ceil', 'floor']) != -1 ? options.roundType : 'round'](multFloats(value, pow))/pow;


        return value;

    }

    function multFloats(a, b){
        var atens = Math.pow(10,String(a).length - String(a).indexOf('.') - 1),
            btens = Math.pow(10,String(b).length - String(b).indexOf('.') - 1);

        return (a * atens) * (b * btens) / (atens * btens);
    }

})();
