include('../common.js');
/**
 * Легковесная поддержка событий без баблинга
 */

common.Observable = {

    calledEventsStats: {},

    bind: function(name, callback) {
        var _this = this;
        $.each(name.split(' '), function(i, name) {
            _this._observersFor(name).push(callback);
        });
        return this;
    },
    
    unbind: function(name, callback) {
        var _this = this;
        if (!this._observers) return this;
        $.each(name.split(' '), function(i, name) {
            if (!callback) {
                _this._observers[name] = undefined;
            } else {
                _this._observers[name] = $.grep(_this._observersFor(name, true), function(c) {
                    return c != callback;
                });
            }
        });
        return this;
    },
    
    trigger: function(name/*, data1, data2*/) {
        var attrs = Array.prototype.slice.call(arguments, 1),
            nameParts = name.split('.'), observers = [];
        observers = this._observersFor(name, true);
        if (nameParts && nameParts[1]) {
            observers = observers.concat(this._observersFor(nameParts[0] + '.*', true))
        }

        $.each(observers, function(i, callback) {
            callback.apply(this, attrs);
        });
        return this;
    },
    
    _observersFor: function(name, skipCreate) {
        this.calledEventsStats[name] = (this.calledEventsStats[name] || 0) + 1;

        if (skipCreate && (!this._observers || !this._observers[name])) return [];
        if (!this._observers) this._observers = {};
        if (!this._observers[name]) this._observers[name] = [];
        return this._observers[name];
    }
};