include('../common.js');
include('observable.js');

(function() {
/**
 * Поддержка поиска chunk-ами
 */
common.Searchable = $.extend({}, common.Observable, {
    chunkSize: 20,
    chunkTimeout: 20,
    
    search: function(query, callback) {
        this.stopSearch();
        
        this._query = query;
        var iterator = this.createIterator(query, callback);

        this.trigger('search.start', iterator);
        filterChunk.call(this, iterator);
    },
    
    stopSearch: function() {
        if (this._searchTimer) {
            clearTimeout(this._searchTimer);
            this._searchTimer = false;
        }
    },
    
    matchRow: function( row, iterator ) { return false },
    
    createIterator: function(query, callback) {
        return {
            query: query,
            iteration: 0,
            found: 0,
            visible: [],
            visibleMap: {},
            callback: callback
        };
    }
});

function filterChunk(iterator) {
    var filtered = 0,
        foundInChunk = [],
        _this = this,
        item;
        
    while(iterator.iteration < this.items.length) {
        if (filtered == this.chunkSize) {
            if (foundInChunk.length) this.trigger('search.foundInChunk', foundInChunk);
            this._searchTimer = setTimeout(function() { filterChunk.call(_this, iterator) }, this.chunkTimeout);
            return;
        }
        item = this.items[iterator.iteration];
        if (this.matchRow( item, iterator )) {
            iterator.found++;
            foundInChunk.push(item)
            iterator.visible.push(iterator.iteration);
            iterator.visibleMap[iterator.iteration] = true;
            this.trigger('search.found', item, iterator);
            if (iterator.callback) iterator.callback(item, iterator);
        } else {
            this.trigger('search.missed', item, iterator);
        }
        iterator.iteration++;
        filtered++;
    }
    if (foundInChunk.length) this.trigger('search.foundInChunk', foundInChunk);
    
    this.stopSearch();
    this.trigger('search.finish', iterator);
};

})();
