include('../common.js');

(function(){

    var AJAX_URL = '/registered/main.pl';

    common.validate = {

        /**
         * Validate phrases
         *
         * @param {String} phrases comma-separated phrases
         * @param {Array} [minusWords]
         * @return {Object} Result object containing boolean property 'valid' and 'error' message
         */
        phrases: function(phrases, minusWords) {
            var result = {
                valid: false,
                message: ''
            };

            $.ajax({
                type: 'POST',
                dataType: 'json',
                async: false,
                url: AJAX_URL,
                data: {
                    cmd: 'ajaxValidatePhrasesForForecast',
                    phrases: phrases,
                    json_minus_words: JSON.stringify(minusWords)
                },
                error: function(xhr, textStatus, e) {
                    result.valid = false;
                },
                success: function(data, textStatus, xhr) {
                    result.message = data.error || '';
                    result.valid = !('error' in data);
                }
            });

            return result;
        }
    };

})();


