include('../background.js');

direct.background.Rows = uki.newClass(uki.background.Rows, new function() {
    var cache = [],
        packSize = 100;
        
    this.init = function(height, color) {
        this._height = height || 20;
        this._color = color || '#CCC';
        this._packSize = packSize;
        this._renderedHeight = 0;
        this._visibleExt = 200;
    };
        
    
    this.layout = function(rect, visibleRect) {
        var height = visibleRect ? visibleRect.height + this._visibleExt*2 : rect.maxY();
        while (this._renderedHeight < height) {
            var h = packSize * this._height,
                c = uki.createElement('div', 'height:' + h + 'px;overflow:hidden;width:100%;', getPackHTML(this._height, this._color));
            this._renderedHeight += h;
            this._container.appendChild(c);
        }
        if (visibleRect) {
            this._container.style.top = Math.ceil((visibleRect.y - this._visibleExt)/this._height)*this._height + 'px';
        }
    };
    
    function getPackHTML (height, color) {
        var key = height,
            row = '',
            html = [],
            i;
        if (!cache[key]) {
            if (uki.dom.offset.boxModel) height--;
            row = ['<div style="height:', height, 'px;width:100%;overflow:hidden;border-bottom:1px solid ' + color + ';"></div>'].join('');
            
            for (i=0; i < packSize; i++) {
                html[i] = row;
            };
            cache[key] = html.join('');
        }
        return cache[key];
    }});