include('../direct.js');

direct.CampOptions = {
    set: function(name, value, callback) {
        var data = {cmd: 'ajaxCampOptions', cid: CAMP_OPTIONS_CID};
        CAMP_OPTIONS[name] = data[name] = value;
        $.ajax({
            type: 'POST',
            url: '/registered/main.pl',
            data: data,
            dataType: 'json',
            success: callback
        });
    },

    update: function(data, callback) {
        var saveData = {cmd: 'ajaxCampOptions', cid: CAMP_OPTIONS_CID};
        $.each(data, function(name, value) {
            CAMP_OPTIONS[name] = saveData[name] = value;
        });
        $.ajax({
            type: 'POST',
            url: '/registered/main.pl',
            data: saveData,
            dataType: 'json',
            success: callback
        });
    },

    remove: function(name, callback) {
        CAMP_OPTIONS[name] = null;
        $.ajax({
            type: 'POST',
            url: '/registered/main.pl',
            data: {cmd: 'ajaxCampOptions', cid: CAMP_OPTIONS_CID, 'delete': name},
            dataType: 'json',
            success: callback
        });
    },

    get: function(name) {
        return CAMP_OPTIONS[name];
    }
};

if (typeof(CAMP_OPTIONS) == 'undefined') CAMP_OPTIONS = {};
