include('../campaign.js');
include('../../common/searchable.js');
include('model.js');

(function() {
    
var totalFields = ['clicks', 'shows', 'showsLeft', 'sumRest', 'sum'];
    
var Searchable = common.Searchable,
    self = direct.campaign.List = function(campaigns) {
        this.init(campaigns);
    };

self.prototype = $.extend({}, Searchable, {
   init: function(campaigns) {
       this.items = campaigns || [];
   },
   
   search: function(query, callback) {
       query.text = query.text.toLowerCase();
       return common.Searchable.search.call(this, query, callback);
   },
   
   matchRow: function(row, iterator) {
       var found = 
           row.searchIndex.indexOf(iterator.query.text) > -1 &&
           (!iterator.query.onlyFavorites || row.favoriteCamp) &&
           (!iterator.query.onlyManagerFavorites || row.my);
           
       return found;
   },
   
   getTotals: function(indexes, visibleMap) {
       var totals = {};
       $.each(totalFields, function() {
           totals[this] = 0;
       });
       for (var i=0, row; i < indexes.length; i++) {
           if (!visibleMap || visibleMap[indexes[i]]) {
               row = this.items[indexes[i]];
               $.each(totalFields, function() {
                   totals[this] += row[this]*1.0;
               });
           }
       };
       return totals;
   }
});

self.fromRawData = function(rawData) {
    return new self($.map(rawData, function(row) {
           return direct.campaign.Model.fromRawData(row);
    }));    
};
})();
