include('../client.js');
include('model.js');
include('../../common/searchable.js');

(function() {
var Searchable = common.Searchable,
    self = direct.client.List = function(clients) {
        this.init(clients);
    };

self.prototype = $.extend({}, Searchable, new function() {
    this.chunkSize = 50;
    this.chunkTimeout = 80;
    
    this.init = function(clients) {
        this.items = clients || [];
    };

    this.matchRow = function(row, iterator) {
        var match = row.matchIndex(iterator.query.text);
        iterator.matchedParent = match == 'parent';
        return !!match;
    };
    
    this.search = function(query, callback) {
        query.text = query.text.toLowerCase();
        return Searchable.search.call(this, query, callback);
    }
});


self.fromRawData = function(rawData) {
    return new self($.map(rawData, function(row) {
       return direct.client.Model.fromRawData(row);
    }));    
};

})();