include('../client.js');
include('../../common/model.js');
(function() {
var self = direct.client.Model = function(data) {
    this.children = [];
    data && this.update(data);
    this.searchIndex = this.buildSearchIndex();
    this.actions = this.actions ? this.actions.push('description') && this.actions : ['description'];
};

self.prototype = $.extend({}, common.Model, new function() {
    this.buildSearchIndex = function() {
        return [this.login,this.fio,this.FIO,this.phone,this.email,this.clientid,this.agency_name,this.description].join('\n').toLowerCase();
    };
    
    this.matchIndex = function(text) {
        for (var i=0; i < this.children.length; i++) {
            if (this.children[i].matchIndex(text)) return 'child';
        };
        if (this.searchIndex.indexOf(text) > -1) return 'parent';
        return 0;
    };
    
    this.setDescription = function(text) {
        this.update({description: text});
        this.searchIndex = this.buildSearchIndex();
    };
    
    this.toTableRow = function(columns) {
        var row = new Array(columns.length);
        for (var i=0; i < columns.length; i++) {
            row[i] = this[columns[i]];
        };
        return row;
    };
});

self.fromRawData = function(rawData) {
    var children = rawData.children || [],
        model = new self(rawData);
        
    rawData.children = undefined;
    
    for (var i=0; i < children.length; i++) {
        model.children[i] = self.fromRawData(children[i]);
    };
    return model;
};

})();
