include('../controller.js');
//include('../layout/description.js');


(function() {
    var description; // one box per page
    var model;
    
    direct.controller.description = function(m, callback) {
        model = m;
        if (!description) {
            description = direct.layout.description().visible(false).attachTo(window, '1000 1000');
            uki('[name=save]', description).click(function() {
                uki('*', description).disabled(true);
                var text = uki('[name=value]', description).value();
                $.ajax({
                    url: '/registered/main.pl',
                    type: 'POST',
                    data: {
                        cmd: 'ajaxSaveUserDescription',
                        description: text,
                        ulogin: model.login
                    },
                    complete: function() {
                        uki('*', description).disabled(false);
                    },
                    success: function(v) {
                        if (v == 1) {
                            description.visible(false);
                            model.setDescription(text);
                            callback();
                        }
                    }
                })
                
            });
            uki('[name=close]', description).click(function() {
                description.visible(false);
            });
        }
        
        description
            .visible(true)
            .layout()
            .find('[name=value]', description)
                .value(m.description || '')
                .focus();
        
    };
    
})();
