include('../view/minusWords/panel.js');
include('../view/minusWords/list.js');
include('../controller.js');
include('../../common/inflector.js');
include('../../common/number.js');

(function() {
    var frame,  // view попап
        result, // view инпут с резултирующим словом,
        list,   // view список слов,
        count,  // число запросов
        minusWordsTips,    // подсказка о минус-словах
        phraseCount, // длина ключевой фразы, включая минус-слова
        countTimeout = null,
        lastCount = 0,
        wordTimeout = null,
        callback,

        wordSuggestionsBlock, // экземпляр Lego.block['b-word-suggestions'] 
        
        $input, // исходный jquery-input
        input,  // инпут для которого все и делаем
        originalWord,
        
        dataForWord = {},
        countCache = {},
        countLoading = false,
        
        baseForms = {}, // исходные формы слов
        baseFormsLoading = false,
        
        data,   // текущие данные
        word,   // строчка текущего слова
        geo,    // строчка с текущим регионом
        generalWords;
    
    direct.controller.refineMinusWords = function(inputOnPage, geoValue, generalMinusWords, callbackParam) {
        if (frame && frame.visible() && !close()) return;
        $input = inputOnPage;
        input = inputOnPage[0];
        wordSuggestionsBlock = inputOnPage.data('wordSuggestionsBlock');
        geo   = geoValue || '';
        originalWord = uki.trim(input.value),
        word  = originalWord.replace(/[\s\n\r]+/g, ' ').replace(/\s-.*/, '');
        data  = dataForWord[geo + '-' + word] = dataForWord[geo + '-' + word] || { words: [], has_more: true, loaded: false };
        callback = callbackParam;
        lastCount = 0;
        countLoading = false;
        createFrame();
        frame.relativeTo(input);
        result.value(input.value);
        updateMinusWords();
        list.attr('data', { words: [], has_more: false, initial: true });
        
        showSlowly(function() {
            list.attr('data', dataForWord[geo + '-' + word])[0].scrollToTop();
            if (!dataForWord[geo + '-' + word].loaded) loadWords(generalMinusWords);
            updateCount();
            updateChanged();
            updatePhraseCount();
        });
    };
    
    function init () {
        word  = curWord();
        data  = dataForWord[geo + '-' + word] = dataForWord[geo + '-' + word] || { words: [], has_more: true, loaded: false };
        lastCount = 0;
        countLoading = false;
        updateMinusWords();
        list.attr('data', dataForWord[geo + '-' + word])[0].scrollToTop();
        if (!dataForWord[geo + '-' + word].loaded) loadWords();
        updateCount();
        updateChanged();
    }
    
    function curWord (argument) {
        return uki.trim(result.value()).replace(/[\s\n\r]+/g, ' ').replace(/\s-.*/, '');
    }
    
    function scheduleUpdateMinusWords () {
        if (wordTimeout) clearTimeout(wordTimeout);
        wordTimeout = setTimeout(updateMinusWords, 500);
    }
    
    function scheduleUpdateCount () {
        if (countTimeout) clearTimeout(countTimeout);
        
        var cached = countCache[geo + '-' + countWord()];
        if (cached) {
            writeCount(cached, true);
        } else {
            countTimeout = setTimeout(updateCount, 5000);
            writeCount(lastCount, false);
        }
    }
    
    function updateCount () {
        countTimeout = null;
        var word = countWord();
        if (countCache[geo + '-' + word]) {
            scheduleUpdateCount();
            return;
        }
        if (countLoading) return;
        countLoading = true;
        $.ajax({
            url: SCRIPT,
            type: 'post',
            data: {
               cmd: "ajaxPhraseStat", 
               geo: geo, 
               w1: word
            },
            success: function(c) {
                countLoading = false;
                countCache[geo + '-' + word] = c;
                scheduleUpdateCount();
            }
        });
    }
    
    function writeCount (number, sure) {
        lastCount = number;
        count.html(iget('Прогноз показов:') + ' <strong' + (sure ? '' : ' style="color: #999"') + '>' + common.number.format(number, {precision: 0}) + '</strong> ' + iget('в месяц') + (sure ? '' : '<img style="position:absolute; margin:2px 0 0 5px;" src="' + uki.theme.imageSrc('loading') + '">'));
    }
    
    function showSlowly (callback) {
        frame.show();
        callback();
    }
    
    function loadWords (generalMinusWords) {
        generalMinusWords && (generalWords = generalMinusWords);

        list.attr('loading', true);
        $.ajax({
            data: { cmd: 'ajaxRefineMinusWords', phrase: requestWord() + (generalWords || ''), geo: geo },
            type: 'POST',
            url: SCRIPT,
            success: function(json) {
                var currentData = eval('(' + json + ')');
                data.has_more = data.has_more && currentData.has_more;
                data.words = data.words.concat(currentData.words);
                // слова из уточнения зарание в базовой форме
                uki.each(currentData.words, function(i, word) {
                    baseForms['-' + word.word] = baseForms['-' + word.word] || [];
                    baseForms['-' + word.word].push('-' + word.word);
                });
                data.loaded = true;
                dataForWord[geo + '-' + word] = data;
                list.attr('loading', false);
                list.attr('data', data);
            }
        });
    }
    
    // бумага гофрированная -цветы
    function loadBaseForms () {
        if (baseFormsLoading) return;
        var unknown = [];
        uki.each(rawMinusWords(), function(i, word) {
            if (!baseForms[word]) unknown.push(word.substr(1));
        });
        if (!unknown.length) return;
        
        baseFormsLoading = true;
        
        $.ajax({
            data: { cmd: 'ajaxNormWords', words: unknown.join(' ') },
            url: SCRIPT,
            type: 'POST',
            success: function(json) {
                var words = eval('(' + json + ')');
                uki.each(words, function(form, base) {
                    baseForms['-' + form] = (baseForms['-' + form] || []).concat(uki.map(base || [], function(w) { return '-' + w }));
                });
                list.attr('baseForms', baseForms);
                baseFormsLoading = false;
            }
        });
    }
    
    function rawMinusWords () {
        var ending = uki.trim(result.value().replace(/[\s\n\r]+/g, ' ').replace(/-\s+/, '-')).split(/\s-/).slice(1).join(' ');
        return uki.map(
                    uki.grep(
                        ending.split(/\s+/),
                        function(w) { return w.match(/\S/); }
                    ),
                    function(w) { return '-' + uki.trim(w) }
                );
    }
    
    function rewriteMinusWords () {
        if (updateMinusWords()) {
            result.value(fullWord());
            loadBaseForms();
            updateChanged();
        }
    }
    
    function updateMinusWords (e) {
        if (curWord() != word) {
            init();
            return false;
        } else {
            wordTimeout = null;
            var minusWords = rawMinusWords();
            list.attr(
                'minusWords', 
                result.value().match('-') ? minusWords : []
            );
            scheduleUpdateCount();
            loadBaseForms();
            updateChanged();
            return true;
        }
    }
    
    function wordSelected() {
        result.value(fullWord());
        updatePhraseCount();
        scheduleUpdateCount();
        updateChanged();
    }
    
    function fullWord () {
        return uki.trim(word + ' ' + list.attr('minusWords').join(' '));
    }
    
    function countWord () {
        return uki.trim(word + ' ' + [].concat(list.attr('minusWords')).sort().join(' '));
    }
    
    function requestWord () {
        var allWords = list.attr('allWords');
        return word + ' ' + allWords.join(' ');
    }
    
    function close () {
        if (changed() && !confirm(iget('Сделанные вами изменения будут потеряны. Продолжить?'))) return false;
        input.value = originalWord;
        wordSuggestionsBlock.data('api').update();
        frame.hide();
        return true;
    }
    
    function changed () {
        return fullWord() != originalWord;
    }
    
    function save () {
        frame.hide();
        if (callback) {
            callback(fullWord());
        } else {
            input.value = fullWord();
        }
    }
    
    var lastChanged;
    function updateChanged () {
        var curChanged = changed();
        if (curChanged !== lastChanged) {
            lastChanged = curChanged;
            uki('[name=save]', frame).text(curChanged ? iget('сохранить') : iget('закрыть'));
        }
    }

    function updatePhraseCount() {
        input.value = result.value();
        var wordSuggestionsAPI = wordSuggestionsBlock.data('api');
        wordSuggestionsAPI.update();
        var charsLeft = parseInt(wordSuggestionsAPI.getCharsLeft(), 10),
            bannersWord = common.inflector.pluralizeWord([iget('знак'), iget('знака'), iget('знаков')], Math.abs(charsLeft)),
            phraseCountPrefix = iget("Внимание! Максимально допустимая длина ключевых фраз превышена на %s", "<span style='color:red; font-weight: bold;'>" + Math.abs(charsLeft) + "</span>");
        phraseCount.html(phraseCountPrefix + bannersWord + ".");
        phraseCount.visible(charsLeft < 0 ? true : false);
        minusWordsTips.visible(charsLeft >= 0 ? true : false);
    }

    function createFrame () {
        if (frame) return;
        
        frame = uki({ 
            view: 'minusWords.Panel', 
            background: 'theme(popup-window)',
            rect: '500 472',
            hideOnClick: false,
            childViews: [
                { view: 'NativeTextarea', rect: '10 10 400 44', anchors: 'left top right', name: 'phrase' },
                
                
                { view: 'Image', name: 'close', rect: '485 10 5 5', anchors: 'right top', src: uki.theme.imageSrc('close-nano'),
                  style: { cursor: 'pointer' }},
                  
                { view: 'Label', name: 'save', rect: '420 10 60 22', anchors: 'right top', text: '',
                  style: { fontSize: '11px', textAlign: 'left', textDecoration: 'underline', cursor: 'pointer' }},
                  
                { view: 'Label', rect: '10 60 480 20', anchors: 'left top right', name: 'count', html: '',
                    textSelectable: true },
                    
                { view: 'Label', name: 'minus-words-tip', rect: '10 94 480 40', anchors: 'left top right', multiline: true,
                    html: iget('Чтобы уточнить ключевую фразу, отметьте нужные минус-слова.<br /><strong>Внимание!</strong> Добавление минус-слова к фразе <strong>исключает</strong> показ объявления по всем запросам, содержащим это слово.') },

                { view: 'Label', name: 'phrase-count', rect: '10 90 465 40', anchors: 'left top right', multiline: false,
                    html: '', background: 'theme(error-message)', inset: '0 0 0 40', style: { border: '1px solid red', background: 'white'} },
                    
                { view: 'minusWords.List', rect: '10 157 480 305', anchors: 'left top right bottom' }
            ]
        })[0];
        
        uki('[name=close]', frame).click(close);
        uki('[name=save]', frame).click(save);
        
        list = uki('minusWords.List', frame)
            .bind('wordSelected', wordSelected)
            .bind('loadMore', loadWords);
            
        result = uki('[name=phrase]', frame)
            .blur(rewriteMinusWords)
            .keyup(updatePhraseCount)
            .keyup(scheduleUpdateMinusWords);
            
        count = uki('[name=count]', frame);
        minusWordsTips = uki('[name=minus-words-tip]', frame);
        phraseCount = uki('[name=phrase-count]', frame);
    }
    
})();
