include('../direct.js');

direct.DateRanges = new function() {

    this.getRangeName = function(from, to) {
        if (to.getTime() > getToday().getTime()) { to = getToday() };
        for (var i in this) {
			if (!this.hasOwnProperty(i) || !this[i].from || !this[i].to) continue;
			if (datesEqual(this[i].from, from) && datesEqual(this[i].to, to)) {
				return i;
			}
		};
		return null;
    }

    this.getRange = function(name) {
        var clone = { from: new Date(), to: new Date() },
            range = this[name];
        clone.from.setTime(range.from.getTime());
        clone.to.setTime(range.to.getTime());
        return clone;
    }
    
    this.today              = { from: getToday(),              to: getEndDate(getToday()) };
    this.lasttoday          = { from: getToday(-7),            to: getEndDate(getToday(-7)) };
    this.yesterday          = { from: getToday(-1),            to: getEndDate(getToday(-1))};
    this.daybeforeyesterday = { from: getToday(-2),            to: getEndDate(getToday(-2))};
    this.lastyesterday      = { from: getToday(-8),            to: getEndDate(getToday(-8)) };
    this.thisweek           = { from: getCurrentWeekDate(),    to: getEndDate(getToday()) };
    this.pastweek           = { from: getCurrentWeekDate(-7),  to: getEndDate(getPrevDate(getCurrentWeekDate())) };
    this.pastpastweek       = { from: getCurrentWeekDate(-14), to: getEndDate(getCurrentWeekDate(-8)) };
    this.last7days          = { from: getToday(-6),            to: getEndDate(getToday()) };
    this.past7days          = { from: getToday(-13),           to: getEndDate(getPrevDate(getToday(-6))) };
    this.last30days         = { from: getToday(-29),           to: getEndDate(getToday()) };
    this.past30days         = { from: getToday(-59),           to: getEndDate(getPrevDate(getToday(-29))) };
    this.thismonth          = { from: getCurrentMonthDate(),   to: getEndDate(getToday()) };
    this.pastmonth          = { from: getCurrentMonthDate(-1), to: getEndDate(getPrevDate(getCurrentMonthDate())) };
    this.pastpastmonth      = { from: getCurrentMonthDate(-2), to: getEndDate(getPrevDate(getCurrentMonthDate(-1))) };
    this.thisyear           = { from: getCurrentYearDate(),    to: getEndDate(getToday()) };
    this.pastyear           = { from: getPastYearDate(),       to: getEndDate(getPrevDate(getCurrentYearDate())) };
    this.twoyearsago        = { from: getTwoYearsAgoDate(),    to: getEndDate(getPrevDate(getPastYearDate())) };
    this.last100years       = { from: getToday(-365*100),      to: getEndDate(getToday()) };
	                           
	                           
   function getDate(day, month, year) {
       var date = new Date(year, month-1, day, 0, 0, 0);
       return date;
   }

   function getEndDate(date) {
       return date;
   }

   function getPrevDate(date) {
       date.setDate(date.getDate() - 1);
       return date;
   }

   function getToday(offset) {
       var date = new Date();
       var result = new Date(date.getFullYear(), date.getMonth(), date.getDate(), 0, 0, 0);
       if (offset) result.setDate(result.getDate() + offset);
       return result;
   }

   function getCurrentWeekDate(offset) {
       var dateOffset = ((new Date()).getDay() + 6) % 7;
       var date = getToday(-dateOffset + (offset || 0));
       return date;
   }

   function getCurrentMonthDate(monthOffset) {
       var date = new Date();
       var result = new Date(date.getFullYear(), date.getMonth() + (monthOffset || 0), 1, 0, 0, 0);
       return result;
   }

   function getCurrentYearDate() {
       return new Date((new Date()).getFullYear(), 0, 1, 0, 0, 0);
   }

   function getPastYearDate() {
       return new Date((new Date()).getFullYear() - 1, 0, 1, 0, 0, 0);
   }

   function getTwoYearsAgoDate() {
       return new Date((new Date()).getFullYear() - 2, 0, 1, 0, 0, 0);
   }

   function getPastDayName(date) {
       return pastDayNames[date.getDay()];
   }

   function datesEqual(date1, date2) {
       return (date1.getDate() == date2.getDate() && date1.getMonth() == date2.getMonth() && date1.getYear() == date2.getYear());
   }
	                           
};