//Управление кампаниями через Excel
include('../direct.js');
include('../common/model.js');

(function() {
    var self = direct.excelCampsManager = function() {
        this.campaigns = [];
        this.current_campaign = 0;
    };
    
    self.prototype = $.extend({}, common.Model, new function() {
        var fields = ['geo_errors', 'errors', 'svars_name', 'has_oversized_banners', 'split_strategy', 'parse_warnings_for_exists_camp'];
        var defaults = {
            'geo_errors': [],
            'errors': [],
            'parse_warnings': [],
            'svars_name': '',
            'camp_number': 0,
            'camp_name': '',
            'cid': 0,
            'has_oversized_banners': 0,
            'split_strategy': 'always_new_banner',
            'parse_warnings_for_exists_camp': {}
        }


        this.clear = function() {
            this.geo_errors = [];
            this.errors = [];
            this.svars_name = '';
            this.campaigns = [];
            this.has_oversized_banners = 0;
            this.trigger('clear');
        }

        this.getCurrentCampaign = function() {
            var camp = this.campaigns[this.current_campaign];
            if (camp) {
                return {
                    'camp_name': camp.camp_name,
                    'parse_warnings': camp.parse_warnings || defaults.parse_warnings,
                    'cid': camp.cid || defaults.cid,
                    'camp_number': camp.camp_number || defaults.camp_number
                }
            } else {
                return {};
            }
        }

        this.getCurrentWarning = function() {
            var camp = this.campaigns[this.current_campaign];
            return (camp) ? camp.parse_warnings || defaults.parse_warnings : defaults.parse_warnings;
        }

        this.setCurrentCampaign = function(num) {
            this.current_campaign = num;
            this.trigger('change_camp')
        }


        this.correctRegion = function() {
            this.geo_errors = [];
            this.trigger('correct_region')
        }


        this.update = function(values) {
            $.each(fields, $.proxy(function(i, field) {
                this[field] = values[field] || defaults[field];
            }, this));
            this.campaigns = values.campaigns || [];

            this.trigger('update')
        },
        


        this.all_errors = function() {
            return this.geo_errors().concat(this.errors())
        }
        
        
    })
    
 })();