include('../direct.js');

(function($){

    var currency = window.currency || 'YND_FIXED',
        pseudo_currency = window.pseudo_currency,
        rate = pseudo_currency && currency == 'YND_FIXED' ? pseudo_currency.rate : 1,
        SLIDER_WIDTH = 500,
        MIN_BUDGET = get_currency(currency).MIN_DAY_BUDGET * rate,
        SLIDER_MIN_UPPER_VALUE = MIN_BUDGET * 10;


    direct.ForecastUtils = {

        getPseudoCurrency: function() {
            return pseudo_currency;
        },

        getCurrency: function() {
            return currency;
        },

        SLIDER_WIDTH: SLIDER_WIDTH,
        MIN_BUDGET: MIN_BUDGET,

        // calcSliderMark -- знает все про разметку слайдера.
        // Может:
        //      дать метки для такой-то координаты слайдера
        //      дать метки для стольки-то денег
        //      дать метки для стольки-то кликов
        // метки: координата, деньги, клики
        // restriction => 'pos|clicks|sum', value => 345
        // результат -- объект вида {pos: 347, sum: 1400, clicks: 100}
        calcSliderMark: function(forecast, restriction, value) {
            var res = new Object;

            var empty_forecast = forecast.left_lim >= forecast.right_lim;

            var left = empty_forecast ? MIN_BUDGET : forecast.left_lim;
            var right = empty_forecast ? SLIDER_MIN_UPPER_VALUE : forecast.right_lim;

            var minClicks = forecast.money2clicks(left);
            var maxClicks = forecast.money2clicks(right);
            if ( maxClicks <= minClicks && ! empty_forecast ) {
                maxClicks = minClicks;
                right = left;
            }

            res.sum = left;
            res.clicks = minClicks;

            // выходы за границы слайдера
            if (restriction != 'pos' && restriction != 'clicks' && restriction != 'sum' )
                return res;

            if (restriction == 'clicks' && value <= minClicks ||
                restriction == 'sum'    && value <= left ||
                restriction == 'pos'    && value <= 0 )
            {
                res.pos = 0;
                res.clicks = minClicks;
                res.sum = left
                return res;
            }


            if (restriction == 'clicks' && value >= maxClicks ||
                restriction == 'sum'    && value >= right ||
                restriction == 'pos'    && value >= SLIDER_WIDTH )
            {
                res.pos = SLIDER_WIDTH;
                res.clicks = maxClicks;
                res.sum = right
                return res;
            }

            // собственно разметка слайдера
            // если понадобится менять шкалу с линейной на логарифмическую, по деньгам вместо кликов -- изменения должны быть только здесь

            res[restriction] = value;

            // обрабатываем нулевой прогноз:
            // шкалу размечаем от 300 до 3000
            if (empty_forecast){
                if (restriction == 'sum'){
                    res.pos = Math.round((res.sum - MIN_BUDGET) * SLIDER_WIDTH / (SLIDER_MIN_UPPER_VALUE - MIN_BUDGET));
                }
                if (restriction == 'pos'){
                    res.sum = MIN_BUDGET + Math.round( res.pos * (SLIDER_MIN_UPPER_VALUE - MIN_BUDGET) / SLIDER_WIDTH );
                }
                return res;
            }
            // нулевой прогноз закончился

            // если шкала линейная по деньгам: деньги <-> клики, деньги <-> позиция на слайдере
            // клики -> сумма
            if (restriction == 'clicks'){
                res.sum = Math.max(forecast.clicks2money(res.clicks), left);
            }

            // сумма -> позизция на слайдере
            if (restriction == 'clicks' || restriction == 'sum'){
                res.pos = Math.round(SLIDER_WIDTH * (res.sum - left) / (right - left));
            }

            // позиция -> сумма
            if (restriction == 'pos'){
                res.sum = Math.round(left + (right - left)*res.pos/SLIDER_WIDTH);
            }

            // сумма -> клики
            if (restriction == 'sum' || restriction == 'pos'){
                res.clicks = forecast.money2clicks(res.sum);
            }
            // конец логики разметки

            res.phrases_cnt = forecast.money2phrases(res.sum);

            return res;
        }
    }


})(jQuery);

