include('../direct.js');

/*
 * Простой хэш для хранения данных
 * Данные добавляются методом init и не могут быть изменены в ходе работы с хэшом
 */
(function() {
    var self = direct.hash = function(data) {
        var storage = {};
        this.init(storage, data);
    }

    self.prototype = function() {
        var methods = {};

        function init(storage, data) {
            for (var name in data) {
                if (!data.hasOwnProperty(name)) return;
                addProp(storage, name);
                storage[ '_' + name ] = data[name];
            }
        }

        function addProp(storage, prop) {
            methods[prop] = function() {
                if (!storage[ '_' + prop ]) return;
                if (storage[ '_' + prop ].constructor === Array) return  storage[ '_' + prop ].concat([]);
                if (typeof storage[ '_' + prop]  == 'object') return $.extend({}, storage[ '_' + prop])
                return  storage[ '_' + prop ];
            };
        }

        methods.init = init;
        return methods;
    }()

})();
