include('../../direct.js');
include('../../common/model.js');
(function() {
    var self = direct.moneyTranfer = function(data, type) {
        data = data || {};
        data.type = 'all2one';
        this.fromHash = {};
        this.toHash = {};
        this.update(data);
    };
    
    self.prototype = $.extend({}, common.Model, new function() {
        
        this.setType = function(type) {
            this.type = type;
            this.from = '', this.to = '';
            this.fromHash = {};
            this.toHash = {}; 
            this.trigger('change.type')    
        }

        this.set = function(id, mode) {
            if (mode == 'from') {
                this.from = id;
                if (this.toHash[id]) { delete(this.toHash[id]); }
            } else {
                this.to = id;
                if (this.fromHash[id]) { delete(this.fromHash[id]); }
            }
            this.trigger('change.transfer-' + mode)
        }

        this.addToHash = function(data, mode) {
            var hash = (mode == 'from') ? this.fromHash : this.toHash;
            for (var cid in data) {
                hash[cid] = data[cid];
            }
            this.trigger('change.transfer-' + mode)
        }
        
        this.deleteFromHash = function(data, mode) {
            var hash = (mode == 'from') ? this.fromHash : this.toHash;
            for (var cid in data) {
                delete(hash[cid]);
            }
            this.trigger('change.transfer-' + mode)
        }
        
        this.resetHash = function(data, mode) {
            if (mode == 'from') {
                this.fromHash = data;    
            } else {
                this.toHash = data;    
            }
            this.trigger('change.transfer-' + mode)
        }
        
        this.clearHash = function(mode) {
            if (mode == 'from') {
                this.fromHash = {};    
            } else {
                this.toHash = {};    
            }
            
            this.trigger('change.transfer-' + mode)   
        }

        this.getSumFrom = function(cid) {
            if (this.type == 'all2one') {
                return this.fromHash[cid];
            } else {
                var sum = 0;
                for (var cid in this.toHash)  {
                    sum += this.toHash[cid] * 1;
                }
                return sum;
            }
        }

        this.getFromCampaigns = function() {
            if (this.type == 'all2one') {
                var fromCamps = [];
                for (var cid in this.fromHash)  {
                    if (this.fromHash[cid] !== undefined) {
                        fromCamps.push(cid);
                    }
                 }
                return fromCamps;
            } else {
                return this.from ? [this.from] : []
            }
        }

        this.getToCampaigns = function() {
            if (this.type == 'one2all') {
                var toCamps = [];
                for (var cid in this.toHash)  {
                    
                    if (this.toHash[cid] !== undefined) {
                        toCamps.push(cid);
                    }
                 }
                return toCamps;
            } else {
                return this.to ? [this.to] : [];
            }
        }



        this.getInfoData = function() {
            var sum = 0, fromNames = '', toNames = '', toCount = 0, fromCount = 0;

            if (this.type == 'all2one') {
                for (var cid in this.fromHash)  {
                    sum += this.fromHash[cid] * 1;
                    if (this.fromHash[cid] !== undefined) {
                        fromCount += 1;
                        fromNames += (fromNames) ? ', ' + this[cid].name + ' (№' + cid + ')' : this[cid].name + ' (№' + cid + ')';

                    }
                 }
                toNames = this.to ? this[this.to].name + ' (№' + this.to + ')' : '';
                toCount = 1;
            } else {
                for (var cid in this.toHash)  {
                    sum += this.toHash[cid] * 1;
                    if (this.toHash[cid]  !== undefined) {
                        toCount += 1;
                        toNames += (toNames) ? ', ' + this[cid].name + ' (№' + cid + ')' : this[cid].name + ' (№' + cid + ')';
                    }
                }
                fromNames = this.from ? this[this.from].name + ' (№' + this.from + ')' : '';
                fromCount = 1;
            }

            sum = common.number.format(sum);

            return {
                sum: sum,
                fromNames: fromNames,
                toNames: toNames,
                toCount: toCount,
                fromCount: fromCount                
            }
        }


    });
})();
