include('../direct.js');
include('background/Rows.js');

(function() {
    var splitterDefaultCss = 'position:absolute;z-index:100;-moz-user-focus:none;font-family:Arial,Helvetica,sans-serif;';
    
    direct.theme = uki.extend({}, uki.theme.Base, {
        imagePath: '/i/theme/',
        
        backgrounds: {
            list: function(rowHeight) {
                return new direct.background.Rows(rowHeight, '#EEEEEE');
            },
            
            'select-bar-focus': function() {
                if (window.opera || uki.browser.cssBoxShadow() == 'unsupported') {
                    return new uki.background.CssBox( 
                        'background:#7594D2;' + (uki.browser.cssFilter() && !window.opera ? 'filter:Alpha(opacity=70);' : 'opacity:0.7;'), 
                        { inset: '-2 -2', zIndex: -2 } 
                    );
                }
                return new uki.background.CssBox(
                    'box-shadow: 0 0 6px #0244D4;',
                    { zIndex: 2, inset: '1' }
                );
                // 
                // if (uki.image.needAlphaFix) return new uki.background.CssBox('filter:progid:DXImageTransform.Microsoft.Blur(pixelradius=3); background:#7594D2;', { inset: '-3 -3 -2 -3', zIndex: -2 } );
                // 
                // var prefix = "button/focusRing-";
                // return new uki.background.Sliced9({
                //     c: [u(prefix + "c.png"), "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAwAAAAMCAYAAABWdVznAAAAtUlEQVQokWNgQABGBof9LNqhq9hkQo9xgjCIDRIDy6GA0FXMKp7b2NX9jvCqJB4S1Y47IgfCIDZYDCgHUgM3GSSgkLBfQCfxoKxO3Ak93fijdiAMYoPEQHJgTWCbgFaCTAFJ6MafMNZNPOGvl3AiC4RBbJAYSA6kBuw8kDtBVoNNBis+WQWzGsQGiYHkwE4F+QnsOaB7QU4AmcqABsA2AeVAakBqSddAspNI9jTpwUpGxJGUNADqMZr1BXNgDAAAAABJRU5ErkJggg=="],
                //     v: [u(prefix + "v.png"), "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAwAAAAUCAYAAAC58NwRAAAAf0lEQVQoU2MQj93JrZlwQlUn/qS3TsLJegY0ABIDyYHUgNQyqPsd4dWJPa6pl3giRDfxeB+6BpAYSA6kBqSWQSl0N79m7FEdvcSTkUA8DV0DSAwkB1IDUgvWoBN3Qk83/ni0buKJGegaQGIgOZCaUQ2jGgZeA0nJm+QMRGoWBQCeEP1BW4HCpgAAAABJRU5ErkJggg=="],
                //     h: [u(prefix + "h.png"), "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACsAAAAMCAYAAAD79EROAAAAOUlEQVRIx2NQCt3NP1Qwg3rkCb2hghl0o45HDxXMoJNwYsZQwQyjYBQMNTCkMtiQKrqGVKUwlKpbALcNHad+5qhBAAAAAElFTkSuQmCC"]
                // }, "6 6 6 6", { inset: '-4 -4 -4 -4', zIndex: 2 });
            },
            
            'select-bar-normal': function() {
                return selectBar(0, '#CCC');
            },
            
            'select-bar-hover': function() {
                return selectBar(20, '#CCC');
            },
            
            'select-bar-checked-normal': function() {
                return selectBar(40, '#9F9281', 'box-shadow: inset 0 0 2px rgba(0,0,0,0.4);');
            },
            
            'select-bar-checked-hover': function() {
                return selectBar(40, '#9F9281', 'box-shadow: inset 0 0 2px rgba(0,0,0,0.4);');
            },
            
            'vtoggle-normal': function() {
                return vtoggle(0, '#D2CDD9');
            },
            
            'vtoggle-hover': function() {
                return vtoggle(0, '#D2CDD9');
            },
            
            'vtoggle-checked-normal': function() {
                return vtoggle(5, '#D2CDD9');
            },
            
            'vtoggle-checked-hover': function() {
                return vtoggle(5, '#D2CDD9');
            },
            
            'select-popup': function() {
                return new uki.background.CssBox('background:white;border:1px solid #CCC;box-shadow: 0 5px 10px rgba(0,0,0,0.5);');
                
                // return new uki.background.Multi(
                //     new uki.background.CssBox('background:white;border:1px solid #CCC'),
                //     uki.theme.background('shadow-medium')
                // );
            },
            
            // 'select-more-popup': function() {
            //     return new uki.background.Multi(
            //         new uki.background.CssBox('background:white;border:1px solid #CCC;border-radius:2px', { inset: '-2 -1' }),
            //         new uki.background.Sliced9(shadowData(), "23 23 23 23", {zIndex: -2, inset: '-3 -6 -10 -6'})
            //     );
            // },
            
            'tab-normal': function() {
                return new uki.background.Null();
            },
            'tab-hover': function() {
                return new uki.background.CssBox('background: #EEEEEE; border-top:2px solid #EEEEEE;', { inset: '-2 0 0 0'} );
            },
            'tab-checked-normal': function() {
                return new uki.background.CssBox('background: #D2CDD9; border-top:2px solid #615770;', { inset: '-2 0 0 0'} );
            },
            
            'browser-shadow': function() {
                return new uki.background.Css({
                    boxShadow: '0 5px 10px rgba(0,0,0,0.5);',
                    MozBoxShadow: '0 5px 10px rgba(0,0,0,0.5)',
                    WebkitBoxShadow: '0 5px 10px rgba(0,0,0,0.5)'
                });
            },
            
            // 'shadow-medium': function() {
            //     if (uki.image.needAlphaFix) 
            //         return new uki.background.CssBox(
            //             'filter:progid:DXImageTransform.Microsoft.Blur(pixelradius=9);background:#000;', 
            //             { inset: '-1 -5 -5 -5', zIndex: -2 } 
            //         );
            //     
            //     return new uki.background.Sliced9(shadowData(), "23 23 23 23", {zIndex: -2, inset: '-1 -6 -6 -6'});
            // },
            
            'more-normal': function() {
                return new uki.background.CssBox('background: url(' + uki.theme.imageSrc('more') + ') 0 0');
            },
            'more-hover': function() {
                return new uki.background.CssBox('background: url(' + uki.theme.imageSrc('more') + ') 0 0');
            },
            'more-checked-normal': function() {
                return new uki.background.CssBox('background: url(' + uki.theme.imageSrc('more') + ') 0 -16px');
            },
            'more-checked-hover': function() {
                return new uki.background.CssBox('background: url(' + uki.theme.imageSrc('more') + ') 0 -16px');
            },
            'popup-window': function() {
                return new uki.background.LinearGradient({
                    startColor: '#FFFFFF',
                    endColor: '#E6E6E6',
                    css: 'border: 1px solid #AAA; border-bottom-color: #888;' + (window.opera && window.opera.version() < 10.6 ? '' : ' box-shadow: 0 5px 10px rgba(0,0,0,0.5);')
                });
            },
            'overlay': function() {
                return new uki.background.CssBox('background-color:#000;opacity:0.2;*Alpha(opacity=20)');
            },
            'error-message': function() {
                return new uki.background.CssBox('background: url(' + uki.theme.imageSrc('error-message') + ') 1.15em 50% no-repeat;');
            }
        },
        
        imageSrcs: {
            x: function() {
                return [u("x.gif"), "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAC0lEQVQIHWNgAAIAAAUAAY27m/MAAAAASUVORK5CYII="]; 
            },
            'select-bar': function() {
                return [u("select/bar.png"), "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAkAAAB3CAYAAADRuWqhAAABc0lEQVRYw+2TQWvCQBCFH8X//wcqPfTSkycLbVGwQsVKo6i0PZTQQwk9SPAgwYNIXzfG1Rh3fbH0mIGPeTv7MrMkG6BMrH/WVGC9MsJDsky0yYKNe5XQlzPTwhQEm06Kkp12i5hubUzxfF/I6/waxU2r8zW4NooPwWdI89G44mY8ix2dZrF3LPJPHujcGgetZ8c6BVZEXyGPdZSZws+QKdE2F3UKglFABf7xjucLq0Le/wj2mvopaVrG3JAWXNqwNWVFe6et0WrsiieAq5je8UPTItoXjXZlWMOpjFMddp2UIc3ZOHsuT846Cc4zJXN3zs40D6lA8h1Qgfjjlgq0GpdUoNO8pgLduxsq0Gs3qMCg26QCw94DFRi/dKjA67hHBd6nAyrwNulTUW7cdPREBSbDLhWYBI9UYDww70KA0XObCgz7LSoQmG+jMKZ7KsqZqqiiiirOitpFjT6kUXaUo6sPUEUVvqhf1elDGmVHOfpPZ/4Fj/em0+D7aZgAAAAASUVORK5CYII=", u("select/bar.gif")];
            },
            'vtoggle-arrows': function() {
                return [u("vtoggle/arrows.gif"), "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAoAAAAICAYAAADA+m62AAAAJUlEQVQY02NggAJft7D/yGx0jCGBTTF+3Wi20ACQZDVRniE2eADToUShFiH+FQAAAABJRU5ErkJggg=="];
            },
            'table-header': function() {
                return [u("table/header.png"), "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAhkAAAASCAYAAAD2QsxhAAAAeElEQVQYGe3BsQ3AQAgEMJBu/3FTQpbgO9v5vm8LAOBYCgDggRQAwAPZ3QIAuJYCAHggBQDwQGamAACupQAAHsjMFADAtexuAQBcy8wUAMC1zEwBAFzL7hYAwLXsbgEAXEt3FwDAtXR3AQBcS3cXAMC1dHcBAFz7Ae9nHBL8yU2KAAAAAElFTkSuQmCC"];
            },
            'more': function() {
                return [u("more/down.png"), "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACMAAAAgCAYAAACYTcH3AAAEOklEQVRYhbWXx0osQRSG+xF8pFm7d2EeVEyYs2LCjHEQcxYxi6KiKCqOGSO6cD+P0G9wbn3FraZsWxcNDnzMmTr/CV2he9pxrM/l5WXSy8tLTOEq5A8hf4x6TtDn4eEh8vj46CrEz9XVlezv72uwgzQhcan7pZGbm5vI/f29GK6vr+Xk5ESOj48lHo/L3t6euK6rwWYMHxq0dmwYqO8tjfqRUIjh6OhIz8Dn56csLS3JxMSE1ww2Y/jQoLVjQ5LQS3ZxcRFVhthw9RSj+Nvbm+zs7HjNYDOGjQatPz4M9OGcnZ3Fz8/PxYYlmJmZ8YoGgQ8NWn98GOjDOT09FZuDgwNZWVmR4eFh2dra0oXZuGNjYxpsxvChQUtMUI7Z2dlvBOkNDldms7y8/G0WRkdHdQLA9vuJsXNsbGz8OKOA318XnMPDQ7FZWFj4FjwyMqL3BmD7/cTYOdhXQTqTC7+/LjimiIGu2Qu9vb2yvr6uE+zu7srg4KAGmzF8aNASE5QHvd0Iv4O0Bmd7eztOpzYUGhoa0nfLn6YaHxq0/njD6uqq9Pf3az3f/P5JSx+OShbd3NwUGzbax8eHTvL6+irl5eVeEyR8fn7WNhq0/nibubk5icVi+vs3HX04i4uLSapAYm1tTQzmyL6/v8vAwID09PR4zbS3t0tfX5/2mVuAHRsG6tOHvgsrI8KRM3CHnZyc1HdbNidXZprBZgwfGrR2bBio/+X5pKY7ooq4yiF+pqenvQ2MHaQJA/WoG/jkVscuSa1tTAlc1viv+J8/Rr3ARvio/ZDU3d0dU3vEZZ/8IS51qBfYSGdnZ6Srq8tViJ+2tjapqanRYAdpQuJS1z8jkY6ODjFQsLGxUerr66W1tVWqq6u9DYzNGD40aO3YMFDfWxpFgiNroBB3yqenJykqKpKcnByvGWzG8KFBa8eGJKGXrKWlJcqV2rAc/C2k+N3dnT5BphlsxrDRoPXHh4E+nObm5rhCbBoaGiQ/P98rGgQ+NGj98SGJO01NTWJTW1srJSUlkpWVJVNTU7rw/Py8Xh7AZgwfGrTEBOWgWT9BeoPDldkUFxd/m4VoNCp1dXUabL+fGDuH/SwLAr+/LjimiKGwsPBbMDNgjja230+MnaOysjJQZ3Lh99cFxxQx0DXTmZqa6r0V8GTOzMzUYJu3BDRoiQnKg95uhN9BWoOjuoxXVVWJTVlZmQ68vb39carxoUHrj7fzpKenaz3fv2npw6moqIgqxKagoEDUm553apKTk70mxsfH9bsONhq0/ngbljA7O1t//6ajD0dtyKTS0tIEXRuYev5kUywjI0Mvh2kmJSVF0tLStA8NWjs2DNSnD30XVsctwpEzcDry8vIkNzdX3225MtMMNmP40KC1Y0Py9fmkpjGiirgk98PVcwoAO0gTBupRN/DJzVSpPRBTIJK/gvzU8Zbm/+cfEiDRvXEl5fUAAAAASUVORK5CYII=", u("more/down.gif")]; 
            },
            'close-nano': function() {
                return [u("close-nano.gif?1"), "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAAG0lEQVQImWNgYGD4z4AK/qMz0BXgFsDQCucDAMmtCPgShKW8AAAAAElFTkSuQmCC"]; 
            },
            'loading': function() {
                return [u('loading.gif'), "data:image/gif;base64,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"];
            },
            'error-message': function() {
                return [u('notice/warning.gif'), "data:image/gif;base64,R0lGODlhEAANAPcAAP//////zP//mf//Zv//M///AP/M///MzP/Mmf/MZv/MM//MAP+Z//+ZzP+Zmf+ZZv+ZM/+ZAP9m//9mzP9mmf9mZv9mM/9mAP8z//8zzP8zmf8zZv8zM/8zAP8A//8AzP8Amf8AZv8AM/8AAMz//8z/zMz/mcz/Zsz/M8z/AMzM/8zMzMzMmczMZszMM8zMAMyZ/8yZzMyZmcyZZsyZM8yZAMxm/8xmzMxmmcxmZsxmM8xmAMwz/8wzzMwzmcwzZswzM8wzAMwA/8wAzMwAmcwAZswAM8wAAJn//5n/zJn/mZn/Zpn/M5n/AJnM/5nMzJnMmZnMZpnMM5nMAJmZ/5mZzJmZmZmZZpmZM5mZAJlm/5lmzJlmmZlmZplmM5lmAJkz/5kzzJkzmZkzZpkzM5kzAJkA/5kAzJkAmZkAZpkAM5kAAGb//2b/zGb/mWb/Zmb/M2b/AGbM/2bMzGbMmWbMZmbMM2bMAGaZ/2aZzGaZmWaZZmaZM2aZAGZm/2ZmzGZmmWZmZmZmM2ZmAGYz/2YzzGYzmWYzZmYzM2YzAGYA/2YAzGYAmWYAZmYAM2YAADP//zP/zDP/mTP/ZjP/MzP/ADPM/zPMzDPMmTPMZjPMMzPMADOZ/zOZzDOZmTOZZjOZMzOZADNm/zNmzDNmmTNmZjNmMzNmADMz/zMzzDMzmTMzZjMzMzMzADMA/zMAzDMAmTMAZjMAMzMAAAD//wD/zAD/mQD/ZgD/MwD/AADM/wDMzADMmQDMZgDMMwDMAACZ/wCZzACZmQCZZgCZMwCZAABm/wBmzABmmQBmZgBmMwBmAAAz/wAzzAAzmQAzZgAzMwAzAAAA/wAAzAAAmQAAZgAAMwAAAP8tLf82Nv88PP9CQv9LS/9XV/9ZWf9aWv9qav94eP+Hh/+Wlv+lpf/Dw//Gxv/Jyf/b2//c3P/e3v/k5P/z8//5+f/8/P///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAO8ALAAAAAAQAA0AAAh1AN8JHMgOW7Z2AxMqDDdunDiFENdlc+dO2zqICb+VAwCg3DeMAst1A3DtGoBv5kBmQ0fSJLptGMeF41iSYzhyCguyo2kSALts7BLe5NiSKLlwA18SXUp0mzqB3MwtrUn03MdyI5hqBTDinDpvI8KKHRsWXLqAADs="];
            }
        },
        
        doms: {
            'resizer': function(height) {
                var template = new uki.theme.Template('position:absolute;width:7px;top:0;right:-4px;height:${height}px;cursor:col-resize;cursor:ew-resize;z-index:101;background:url(' + uki.theme.imageSrc('x') + ')'),
                    node = uki.createElement('div', template.render({height:height}));
                    
                if (!node.style.cursor || window.opera) node.style.cursor = 'e-resize';
                return node;
            },
            'splitPane-vertical': function(params) {
                var commonVerticalStyle = 'cursor:row-resize;cursor:ns-resize;z-index:200;overflow:hidden;',
                    handle = params.handleWidth == 1 ?
                    uki.createElement('div', 
                        splitterDefaultCss + 'width:100%;height:5px;margin-top:-2px;' + 
                        commonVerticalStyle + 'background: url(' + uki.theme.imageSrc('x') + ')',
                        '<div style="' + 
                        splitterDefaultCss + 'background:#999;width:100%;height:1px;left:0px;top:2px;overflow:hidden;' + 
                        '"></div>') :
                    uki.createElement('div', 
                        splitterDefaultCss + 'width:100%;height:' + (params.handleWidth - 2) + 'px;' +
                        'border: 1px solid #CCC;border-width: 1px 0;' + commonVerticalStyle +
                        'background: url(' + uki.theme.imageSrc('splitPane-vertical') + ') 50% 50% no-repeat;');
                if (!handle.style.cursor || window.opera) handle.style.cursor = 'n-resize';
                return handle;
            },
            
            'splitPane-horizontal': function(params) {
                var commonHorizontalStyle = 'cursor:col-resize;cursor:ew-resize;z-index:200;overflow:hidden;',
                    handle = params.handleWidth == 1 ?
                    uki.createElement('div', 
                        splitterDefaultCss + 'height:100%;width:5px;margin-left:-2px;' + 
                        commonHorizontalStyle + 'background: url(' + uki.theme.imageSrc('x') + ')',
                        '<div style="' + 
                        splitterDefaultCss + 'background:#CCC;height:100%;width:1px;top:0px;left:2px;overflow:hidden;' + 
                        '"></div>') :
                    uki.createElement('div', 
                        splitterDefaultCss + 'height:100%;width:' + (params.handleWidth - 2) + 'px;' +
                        'border: 1px solid #CCC;border-width: 0 1px;' + commonHorizontalStyle + 
                        'background: url(' + uki.theme.imageSrc('splitPane-horizontal') + ') 50% 50% no-repeat;');
                if (!handle.style.cursor || window.opera) handle.style.cursor = 'e-resize';
                return handle;
                
            }
        },
                
        templates: {
            'table-header-cell': function() {
                var image = uki.theme.imageSrc('table-header');
                return new uki.theme.Template(
                    '<div style="position:relative;border:1px solid #CCC;border-top:none;border-left:none;background:#F1EEF5;line-height:19px;'+
                    'background-image: url(' + image + ');' +
                    'font-size:11px;' +
                    '${style}" class="${className}">${data}</div>');
            },
            
            'table-cell': function() {
                return new uki.theme.Template(
                    '<div style="position:relative;margin-right:1px;height:100%;'+
                    '${style}" class="${className}">${data}</div>');
            }
        },
        styles: {
            base: function() {
                return 'font-family:Arial,Helvetica,sans-serif;font-size:12px;line-height:15px;';
            },
            'label': function() {
                return 'text-overflow: ellipsis;';
            },
            'button': function() {
                return 'text-align: center';
            }
        }
    });

    direct.theme.backgrounds['select-bar-focus'];
    direct.theme.backgrounds['tab-checked-hover'] = direct.theme.backgrounds['tab-checked-normal'];
    uki.theme.register(direct.theme);
    
    
    function u(url) {
        return direct.theme.imagePath + url;
    }
    
    function selectBar (offsetTop, borderColor, css) {
        var url = uki.theme.imageSrc('select-bar');
        return new uki.background.CssBox(
            'background: url(' + url + ') 0 -' + offsetTop + 'px repeat-x; border: 1px solid ' + borderColor + ';' + (css || ''),
            { innerHTML: '<div style="position: absolute; right: 5px; top: 9px; width: 9px; height: 4px; background: url(' + url + ') 0 -90px"></div>' }
        );
    }
    
    function vtoggle (offset, color) {
        var url = uki.theme.imageSrc('vtoggle-arrows');
        return new uki.background.CssBox(
            'background: ' + color + '; border-right: 2px solid #615770',
            { innerHTML: '<div style="position: absolute; overflow: hidden; right: 5px; top: 7px; width: 5px; height: 8px; background: url(' + url + ') -' + offset + 'px 0px"></div>' }
        );
    }
    
    // function shadowData() {
    //     var prefix = "shadow/large-";
    //     return {
    //         c: [u(prefix + "c.png"), "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAC4AAAAuCAYAAABXuSs3AAACzklEQVRo3t2a63KiUBCEPYCX1U2Ixvd/Qm/kYjRBWd2aTjW950CS3fyYtaprULl8p2kGAcMg/QqR6SDTsXk/8moi041Mx+bt3WAKVDVIDOQj0ArcROCbFHzoAGbYTICzLwygC/jc8T62bGccFDKLKLUXeH2625sIpCo2mBa8bkiBWbkpo5oaQMrxFPCJ6ikxkNYAQg90Tiqk5h0DiDmeAoZqqTqIFrxuSB0uSENTQVUHkHJdnVbgN6qYrmkQ6n7U6VygRwY6Eg1pHiyDdcQcx0YZGLCvInxWyx44q+Nwi6Hh8Ng0kTqieTQ2QcCbSDzeCPB40UHqUfYAlvu9Lu0aDD0i0B+iiQnup1wfdLgNdw+mFxEG8CrwZziuB6JCT00zqQyfcn3Q4TZD7y96lrqPwL9HJkiLKygecPcK+tN0Y3VG348lMlnC8bNE5EjuXmGfLnq0+mSf4fujuh6kM8DtCUHfmG6pMry63uc4u83QDwaO+kjwB3U9SD45InD61lSS4PzU4GNxUXCNyYvFAU5XpAcTnOfI/AFeiNuIxhX0TgT3pxKXoge8lpjsyeWdqKLosOs1wIcEzgck3L6Czk0Le1/ad7O/BH826MpgNxdtTTtynQ/UFngh4DNym6HvbfqO4oKcfwYc+UZMdga7FviKss7gdbB45NJNAA637wl8QXFBzsfSz7vAccLZ00EJt9dU4TofpOgup0AbLKSbICYAZiEu3NM/6zh6NmKyFm0oLtxdWo5z/8ZJpiTwpYDPxfGvgsPxrUCvCLyik9J7P1dw7igAB+zStDDw8h+BVwa+MeAVDQDg3FmS4NxR5gTN9TvA1wS9opxrZ+kFL6mbLEnfDb6iqGzJ8f8f3F1UXB6cLtuhyxOQy1O+2x9Zbn/Wur2QcHvp5vZi2e3tCbc3hNzegnN709P1bWaXN/bdPkpx/fDK9eNCtw9oXT8Sd/MnhF+iLpLibpmRrgAAAABJRU5ErkJggg==", u(prefix + "c.gif")],
    //         v: [u(prefix + "v.png"), "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAC4AAAAECAYAAADxjg1nAAAAWklEQVQYGdXBWwpAQAAAwLEeSUqy9z/hSkpSnh9OsTMFGlSo0aJDjwEjJkREREwYMaBHhxY1KpQIKPxePLhx4cSBHRtWLJiRkJAwY8GKDTsOnLiCTAWZCjL1AeihFg5/1kytAAAAAElFTkSuQmCC", u(prefix + "v.gif")],
    //         h: [u(prefix + "h.png"), "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAQAAAAuCAYAAAAPxrguAAAAe0lEQVQoz5XSWwtAQBCG4XEMOST+/y8kOYScKRe8WzZbc7FPX7PNtLaIuPI49l0vUBIewT/LuO/7BRETMRMpExkh/w9KD+WVhBASAu20jnZjFsEkGAQh7ISNsBIWwkwYCT2hI9SEilASiv+g9KgEH6ZhomVi0E47fW7sAEmnGr/QVlzBAAAAAElFTkSuQmCC", u(prefix + "h.gif")],
    //         m: [u(prefix + "m.png"), "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAQAAAAECAYAAACp8Z5+AAAAEUlEQVQIHWNgYGD4i4ZJFQAAAkoP0RsgosoAAAAASUVORK5CYII=", u(prefix + "m.gif"), true]
    //     };
    // };
    
})();
