include('../direct.js');
include('../common/number.js');
include('utils.js');

(function() {
    /*
     * condition - необходимость валидации
     * preprocess - обработка значения переред валидацией
     */
    function validator(value, params, validatorName) {
        if ($.isFunction(params.condition) && !params.condition.call(this)) {
            return true;
        }
        if ($.isFunction(params.preprocess)) {
            value = params.preprocess.call(this, value);
        }

        //если в валидаторe прописана своя валидирующая функция - дергаем её,
        //если нет - пытаемся использовать дефолтный из кэша
        if ($.isFunction(params.validate)) {
            return params.validate.call(this, value, params);
        } else if (!$.isFunction(validatorsCache[validatorName])){
            return true;
        } else {
            return validatorsCache[validatorName].call(this, value, params);
        }

    }

    var validatorsCache = {
        maxlength: function(value, params) {
            if (typeof value != 'object') { value = value+''; }
            return value.length <= params.max;
        },


        max: function(value, params) {
            return (value && !isNaN(value)) ? value * 1 <= params.max * 1 : true;
        },

        maxfield: function(value, params) {
            var max = params.getmax.call(this);
            return (max && !isNaN(max)) ? value * 1 < max : true;

        },

        min: function(value, params) {
            return (value && !isNaN(value)) ? value * 1 >= params.min * 1 : true;
        },

        format: function(value, params) {
            switch (params.format) {
                case 'decimal':
                    return direct.utils.isEmpty(value) || common.number.isDecimal(value);
                case 'integer':
                    return direct.utils.isEmpty(value) || common.number.isInteger(value);
                default:
                    return direct.utils.isEmpty(value) || params.formater(value);
            }
            return true;
        },


        required: function(value, params) {
            return !direct.utils.isEmpty(value);
        }
    };

    direct.validators = {
        validate: function(value, rules, model) {
            var errors = [];
            if (rules.required) {
                if (!validator.call(model, value, rules.required, 'required')) {
                    return ['required']
                }
            }
            $.each(rules, function(rule, params) {
                if (rule == 'required') { return true }

                if (!validator.call(this, value, params, rule)) {
                    errors.push(rule)
                }
            });
            return errors;
        },

        validateModel: function(model) {
            var errors;
            if (!model.validateSchemes) { return; }
            var allSchemes = $.isFunction(model.validateSchemes) ?  model.validateSchemes() : model.validateSchemes;

            for (var name in allSchemes) {
                var schemes = allSchemes[name];

                if ($.isFunction(schemes.condition) && !schemes.condition.call(model)) {
                    continue;
                }
                for (var rule in schemes) {
                     if (!validator.call(model, model.get(name), schemes[rule], rule)) {
                         if (!errors) { errors = {}; }
                         if (!errors[name]) { errors[name] = [];}
                         errors[name].push(rule);
                         //если значение не введено или введено в неправильном формате - дальше не проверяем
                         if (rule == 'required' || rule == 'format') { break; }

                     }
                 }
            };
            return errors;
        }
    };
})();
