include('../view.js');

// flow with support for contentResized event
uki.view.declare('direct.view.AutoVFlow', uki.view.VFlow, function(Base) {
    this.appendChild = function(child) {
        this._registerChild(child);
        return Base.appendChild.call(this, child);
    };
    
    this.insertBefore = function(child, before) {
        this._registerChild(child);
        return Base.insertBefore.call(this, child, before);
    };
    
    this.removeChild = function(child) {
        this._unregisterChild(child);
        return Base.removeChild.call(this, child);
    };
    
    this._registerChild = function(child) {
        child.bind('contentResized', uki.proxy(this._childResized, this))
    };
    
    this._unregisterChild = function(child) {
        child.unbind('contentResized', this._childResized);
    };
    
    this._childResized = function() {
        this._contentChanged = true;
    };
    
    this._layoutChildViews = function() {
        Base._layoutChildViews.call(this);
        if (this._contentChanged) {
            this.resizeToContents('height');
            this.layout();
            this.trigger('contentResized');
        }
    };
});