include('../view.js');

uki.view.declare('direct.view.DomPopup', uki.view.Popup, function(Base) {
    var ANCHOR_TOP    = 1,
        ANCHOR_RIGHT  = 2,
        ANCHOR_BOTTOM = 4,
        ANCHOR_LEFT   = 8,
        ANCHOR_WIDTH  = 16,
        ANCHOR_HEIGHT = 32
        
        Rect = uki.geometry.Rect;
        
    this._recalculateRect = function() {
        if (!this.visible()) return this._rect;
        
        var relativeOffset = uki.dom.offset(this._relativeTo),
            relativeRect = new Rect(0, 0, this._relativeTo.offsetWidth, this._relativeTo.offsetHeight),
            rect = this.rect().clone(),
            attachment = uki.view.top(this),
            attachmentRect = attachment.rect(),
            attachmentOffset = uki.dom.offset(attachment.dom()),
            position = new uki.geometry.Point(),
            hOffset = this._horizontal ? this._offset : 0,
            vOffset = this._horizontal ? 0 : this._offset;
            

        relativeOffset.offset(-attachmentOffset.x, -attachmentOffset.y);

        if (this._anchors & ANCHOR_RIGHT) {
            position.x = relativeOffset.x + relativeRect.width - (this._horizontal ? 0 : rect.width) + hOffset;
        } else if (this._anchors & ANCHOR_LEFT) {
            position.x = relativeOffset.x - (this._horizontal ? rect.width : 0) - hOffset;
        } else {
            position.x = relativeOffset.x + ((relativeRect.width - rect.width) >> 1) - hOffset;
        }
        
        if (this._anchors & ANCHOR_BOTTOM) {
            position.y = relativeOffset.y + (this._horizontal ? relativeRect.height : 0) - rect.height - vOffset;
        } else if (this._anchors & ANCHOR_TOP) {
            position.y = relativeOffset.y + (this._horizontal ? 0 : relativeRect.height) + vOffset;
        } else {
            position.y = relativeOffset.y + ((relativeRect.height - rect.height) >> 1) + vOffset;
        }
        
        return new Rect(position.x, position.y, rect.width, rect.height);
    };    
    
    /**
    * @function
    * @name uki.view.Popup#hideOnClick
    */
    this.hideOnClick = function(state) {
        if (state === undefined) return this._clickHandler;
        if (state != !!this._clickHandler) {
            if (state) {
                this._clickHandler = this._clickHandler || uki.proxy(function(e) {
                    if (uki.dom.contains(this._relativeTo, e.target)) return;
                    if (uki.dom.contains(this.dom(), e.target)) return;
                    this.hide();
                }, this);
                uki.dom.bind(document.body, 'mousedown', this._clickHandler);
                uki.dom.bind(window, 'resize', this._clickHandler);
            } else {
                uki.dom.unbind(document.body, 'mousedown', this._clickHandler);
                uki.dom.unbind(window, 'resize', this._clickHandler);
                this._clickHandler = false;
            }
        }
        return this;
    };
    
});