include('../minusWords.js');
include('listItem.js');
include('../autoFlow.js');

uki.view.declare('direct.view.minusWords.List', uki.view.Box, function(Base) {
    this._data = {words: []};
    this._minusWords = [];
    this._baseForms = {};
    
    this._createDom = function() {
        Base._createDom.call(this);
        var rect = this.rect();
        this.rect('480 320');
        
        uki([
            { view: 'Label', rect: '40 0 200 20', anchors: 'left top', style: { fontSize: '11px' }, text: iget('Минус-слово') },
            { view: 'Label', rect: '230 0 200 20', anchors: 'left top', style: { fontSize: '11px' }, text: iget('Примеры запросов с минус-словом') },
            { view: 'Box', rect: '0 20 480 300', anchors: 'left right top bottom',
                background: 'cssBox(background:#FFF;border:1px solid #CCC)',
                childViews: { view: 'ScrollPane', 
                    rect: '480 300', anchors: 'left right top bottom', 
                    childViews: { view: 'VFlow', rect: '480 200', anchors: 'left top right' }
                 }
             }                    
        ]).appendTo(this);
        
        this._flow = uki('VFlow', this);
        this._scrollPane = this._flow.parent();
        // this._flow.bind('contentResized', uki.proxy(function() {
        //     this._scrollPane.layout();
        // }, this));
        this.rect(rect);
    };
    
    this.baseForms = uki.newProp('_baseForms', function(v) {
        this._baseForms = v;
        this._updateListItems();
    })
    
    this.minusWords = uki.newProp('_minusWords', function(v) {
        this._minusWords = v;
        this._updateListItems();
    });
    
    this.scrollToTop = function() {
        this._scrollPane[0].scrollTop(0);
    };
    
    this.allWords = function() {
        return uki.map(uki('> minusWords.ListItem', this._flow), 'word');
    };
    
    this._updateListItems = function() {
        var index = {};
        for (var i=0; i < this._minusWords.length; i++) {
            index[this._minusWords[i]] = true;
            var baseForms = this._baseForms[this._minusWords[i]];
            if (baseForms) for (var j=0; j < baseForms.length; j++) index[baseForms[j]] = true;
        };
        uki('> minusWords.ListItem', this._flow).each(function() {
            this.checked(!!index[this.word()]);
        });
    };
    
    this.loading = uki.newProp('_loading', function(v) {
        this._loading = v;
        uki('[name=load_more]', this)
            .html(this._moreHtml())
            .style({
                cursor: v ? 'default' : 'pointer',
                textDecoration: v ? 'none' : 'underline',
                color: v ? '#000000' : '#1A3DC1'
            });
    });
    
    this._moreHtml = function() {
        return this._loading ? 
            '<img style="position:absolute;left:50%;top:50%;margin:-8px 0 0 -4.2em;" src="' + uki.theme.imageSrc('loading') + '">' + iget('загрузка') + '&hellip;' : 
            iget('Загрузить еще');
    };
    
    this.data = function(v) {
        if (v === undefined) return this._data;
        
        this._data = v;
        var width = this._flow.rect().width;
        // строчки со словами
        var views = uki.map(v.words, function(item) {
            return { view: 'minusWords.ListItem', rect: width + ' 85', anchors: 'left top right', word: '-' + item.word, 
                examples: item.phrases.slice(0, 5).join(', '), count: item.exact_cnt || item.cnt };
        });
        // кнопка загрузить еще
        if (v.has_more) views.push({ view: 'Label', rect: width + ' 50', anchors: 'left top right', html: '',
            style: { cursor: 'pointer', textDecoration: 'underline', textAlign: 'center', fontWeight: 'bold' }, name: 'load_more' });
            
        if (!v.has_more && v.words.length == 0 && !v.initial) {
            views.push({ view: 'Label', rect: width + ' 50', inset: '20 20 0 40', anchors: 'left top right', 
            multiline: true,
            html: iget('На основании статистики поисковых запросов нет возможности уточнить данную ключевую фразу добавлением минус-слов.') })
        }
            
        // чистим старых детей, чтобы не было ненужных ссылок в памяти
        uki.each(this._flow.childViews(), function() { this.unbind('wordSelected contentResized'); });
        
        // рисуем новых детей
        this._flow.childViews(views).resizeToContents('height').layout();
        this._updateListItems();
        this.loading(this.loading());
        this._scrollPane.layout();
            
        
        // биндим эвенты
        var _this = this;
        uki('> minusWords.ListItem', this._flow).bind('wordSelected', function() {
            var word = this.word();
            if (this.checked()) {
                _this._minusWords.push(word);
            } else {
                _this._minusWords = uki.grep(_this._minusWords, function(w) {
                    return w != word;
                });
            }
            _this.trigger('wordSelected');
        });
        if (v.has_more) uki('[name=load_more]', this).click(function() {
            if (_this.loading()) return;
            _this.trigger('loadMore');
        });
        return this;
    };
});