include('../minusWords.js');
include('../../../common/format.js');

uki.view.declare('direct.view.minusWords.ListItem', uki.view.Box, function(Base) {
    this.word = function(v) {
        if (v === undefined) return this._word.html();
        this._word.html(v);
        return this;
    };
    
    this.examples = function(v) {
        if (v === undefined) return this._examples.innerHTML;
        this._examples.innerHTML = v;
        return this;
    };
    
    this.count = function(v) {
        this._count.innerHTML = '<strong>-' + common.number.format(v, {precision: 0}) + '</strong> ' + iget('показов в месяц');
    };
    
    uki.delegateProp(this, 'checked', '_checkbox');
    
    this._createDom = function() {
        Base._createDom.call(this);
        var rect = this.rect();
        this.rect('630 40');
        
        uki([
            { view: 'NativeCheckbox', rect: '10 10 22 15', anchors: 'left top' },
            { view: 'Label', rect: '40 10 180 30', anchors: 'left top',
                multiline: true, style: {overflow: 'hidden', fontSize: '16px', cursor: 'default'} }
        ]).appendTo(this);
        
        this._checkbox = this.childViews()[0];
        this._word = this.childViews()[1];

        var _this = this;
        this._word.bind('click', function() {
            this.prevView().value(!this.prevView().value());
            _this.trigger('wordSelected');
        });
        this._checkbox.bind('click', function() {
            _this.trigger('wordSelected');
        });
        this.style({ borderBottom: '1px dotted #CCC'});
        
        this._examples = uki.createElement('div', uki.theme.style('base') + ';margin: 10px 10px 0 230px');
        this._count    = uki.createElement('div', uki.theme.style('base') + ';left: 40px; top: 30px; font-size: 11px; position: absolute;');
        this.dom().appendChild(this._examples);
        this.dom().appendChild(this._count);
        
        this.rect(rect);
    };
    
    this.desiredHeight = function() {
        return Math.max(this._examples.offsetHeight + 20, 55);
    };
    
    this._layoutChildViews = function() {
        Base._layoutChildViews.call(this);
        var h = this.desiredHeight();
        if (h != this.rect().height) {
            this.rect().height = h;
            this._needsLayout = true;
            this.parent().childResized(this);
            this.trigger('contentResized');
        }
    };
    
});