include('../minusWords.js');

uki.view.declare('direct.view.minusWords.Panel', uki.view.Popup, function(Base) {
    this._recalculateRect = function() {
        if (!this.visible()) return this._rect;
        
        var relativeOffset = uki.dom.offset(this._relativeTo),
            relativeRect = new uki.geometry.Rect(0, 0, this._relativeTo.offsetWidth, this._relativeTo.offsetHeight),
            rect = this.rect().clone(),
            attachment = uki.view.top(this),
            attachmentRect = attachment.rect(),
            attachmentOffset = uki.dom.offset(attachment.dom()),
            position = new uki.geometry.Point();

        relativeOffset.offset(-attachmentOffset.x, -attachmentOffset.y);

        position.x = relativeOffset.x - 10;
    
        position.y = relativeOffset.y - 10;
        
        return new uki.geometry.Rect(position.x, position.y, relativeRect.width + 100, rect.height);
    };    
    
    /**
    * @function
    * @name uki.view.Popup#hideOnClick
    */
    this.hideOnClick = function(state) {
        if (state === undefined) return this._clickHandler;
        return this;
    };
    
});