include('../view.js');

uki.view.declare('direct.view.OldSchoolList', uki.view.List, function(Base) {
    this._bindSelectionEvents = function() {
        this.bind('click', this._click);
        
        // this.bind('mousedown', this._mousedown);
        // this.bind('mouseup', this._mouseup);
        // this.bind(this.keyPressEvent(), this._keypress);
    };
    
    this._click = function(e) {
        
        if (e.target.className.indexOf('old-school-checkbox') > -1) {
            var o = uki.dom.offset(this._dom),
                y = e.pageY - o.y,
                p = y / this._rowHeight << 0,
                indexes = this._selectedIndexes,
                selectionPos = uki.binarySearch(p, indexes);
                
            if (e.target.checked) {
                indexes.splice(selectionPos, 0, p);
            } else {
                if (indexes[selectionPos] != p) return;
                indexes = indexes.slice(0,selectionPos).concat(indexes.slice(selectionPos+1));
            }
            this.selectedIndexes(indexes);
            this._lastClickIndex = p;
        }
    };
    
    this._restorePackSelection = function(pack) {
        var indexes = this._selectedIndexes;
        
        if (
            (indexes[0] <= pack.itemFrom && indexes[indexes.length - 1] >= pack.itemFrom) || // left index
            (indexes[0] <= pack.itemTo   && indexes[indexes.length - 1] >= pack.itemTo) || // right index
            (indexes[0] >= pack.itemFrom && indexes[indexes.length - 1] <= pack.itemTo) // within
        ) {
            var currentSelection = uki.binarySearch(pack.itemFrom, indexes);
            currentSelection = Math.max(currentSelection, 0);
            while(indexes[currentSelection] !== null && indexes[currentSelection] < pack.itemTo) {
                var position = indexes[currentSelection] - pack.itemFrom;
                this._render.setSelected(pack.dom.childNodes[position], this._data[position], true, this.hasFocus());
                var cb = pack.dom.childNodes[position].getElementsByTagName('input')[0];
                if (cb) cb.checked = true;
                currentSelection++;
            }
        }
    };
    
    this._setSelected = function(position, state) {
        var item = this._itemAt(position);
        if (item) {
            this._render.setSelected(item, this._data[position], state, this.hasFocus());
            var cb = item.getElementsByTagName('input')[0];
            if (cb) cb.checked = state;
        }
    };
    
    
    this._focus = function(e) {
        uki.view.Focusable._focus.call(this, e);
        this.selectedIndexes(this.selectedIndexes());
    };
    
});