include('../splitTable.js');

direct.view.splitTable.Render = uki.newClass(uki.view.table.Render, function(Base) {
    this._parentTemplate = new uki.theme.Template(
        '<div class="${classPrefix}-row ${classPrefix}-${opened}" style="margin-left:${indent}px">' + 
            '<div class="${classPrefix}-toggle"><i class="toggle-tree"></i></div>${text}' +
        '</div>'
    );

    this._leafTemplate = new uki.theme.Template(
        '<div class="${classPrefix}-row" style="margin-left:${indent}px">${text}</div>'
    );
    
    this.initStyles = function() {
        this.classPrefix = 'treeList-' + uki.dom.guid++;
        var style = new uki.theme.Template(
            '.${classPrefix}-row { color: #333; position:relative; padding-top:3px; } ' +
            '.${classPrefix}-selected { background: #C6C1DC; } ' +
            '.${classPrefix}-selected .${classPrefix}-row { color: #FFF; } ' +
            '.${classPrefix}-selected i { left: -10px; } ' +
            '.${classPrefix}-selected-blured { background: #CCCCCC; } ' +
            '.${classPrefix}-opened i { top: -9px; }'
        ).render({ 
            classPrefix: this.classPrefix
        });
        uki.dom.createStylesheet(style);
    };

    this.render = function(row, rect, i) {
        this.classPrefix || this.initStyles();
        return Base.render.call(this, row, rect, i);
    };
    
    this.setSelected = function(container, data, state, focus) {
        container.className = !state ? '' : this.classPrefix + '-selected';
    };

});