
function advanced_forecast_main_loop(segments, restrictions, options, currency)
{
    var res = {
        yandex: {clicks: 0, shows: 0, sum: 0, amnesty_price: 0, phrases: {}},
        total: {clicks: 0, shows: 0, sum: 0, amnesty_price: 0}
    };

    currency = currency || 'YND_FIXED';

	var place = restrictions.place ? restrictions.place : 'total',
        currencyObject = get_currency(currency);


    for (var i = 0; i < segments.length; i++ ) {
        var s = segments[i];
        var phrase_id = s.phrase_id;
        if ( options.hasOwnProperty('disabledPhrases') && options.disabledPhrases.hasOwnProperty(phrase_id) ){
            continue; 
        }

        // break, если res.complete или кликов/показов/денег сколько надо
        if ( restrictions.type == 'clicks' && res[place].clicks >= restrictions.clicks 
          || restrictions.type == 'shows'  && res[place].shows  >= restrictions.shows 
          || restrictions.type == 'sum'    && res[place].sum    >= restrictions.sum 
          || restrictions.type == 'amnesty_price'    && res[place].amnesty_price    >  restrictions.amnesty_price
          || restrictions.type == 'cent1'  && s.yandex.delta_sum > s.yandex.delta_clicks * currencyObject.MIN_PRICE
          || restrictions.type == 'min'  && (
                res[place].clicks >= currencyObject.MIN_AUTOBUDGET_CLICKS_BUNDLE &&
                res[place].sum >= currencyObject.MIN_AUTOBUDGET &&
                res[place].amnesty_price >= currencyObject.MIN_AUTOBUDGET_AVG_PRICE
            )
           ){

            break;
        }

        // характеристики следующей точки на ломаной
        var whole_delta_clicks = 0,
            whole_delta_sum = 0,
            whole_delta_shows = 0;

        whole_delta_clicks += s.yandex.delta_clicks;
        whole_delta_sum += s.yandex.delta_sum;
        whole_delta_shows += s.yandex.delta_shows;

        var clicks_next = res.total.clicks + whole_delta_clicks,
            shows_next  = res.total.shows  + whole_delta_shows,
            sum_next    = res.total.sum    + whole_delta_sum,
            amnesty_price_next    = Math.round( 100 * sum_next / clicks_next) / 100;

        var whole_segment = 0,
            segment_part = 0;
        if ( restrictions.type == 'clicks' && clicks_next <= restrictions.clicks
          || restrictions.type == 'shows'  && shows_next  <= restrictions.shows
          || restrictions.type == 'sum'    && sum_next    <= restrictions.sum
          || restrictions.type == 'amnesty_price'    && amnesty_price_next    <= restrictions.amnesty_price
          || restrictions.type == 'unlim'
          || restrictions.type == 'cent1'
          || restrictions.type == 'min'
           ){
            // берем сегмент целиком
            whole_segment = 1;
            segment_part = 1;
        } else if ( restrictions.type == 'clicks' ) {
            delta_clicks = restrictions.clicks - res.total.clicks;
            segment_part = delta_clicks / whole_delta_clicks;
        } else if ( restrictions.type == 'shows' ) {
            delta_shows  = restrictions.shows - res.total.shows;
            segment_part = delta_shows / whole_delta_shows;
        } else if ( restrictions.type == 'sum' ) {
            delta_sum    = restrictions.sum - res.total.sum;
            segment_part = delta_sum / whole_delta_sum;
        } else if ( restrictions.type == 'amnesty_price' ) {
            // segment_part (=x) выведено из соотношения:
            // ( sum_1 + x * delta(sum) ) / (clicks_1 + x * delta(clicks) ) = restrictions.cpc
            segment_part = ( res.total.sum - restrictions.amnesty_price * res.total.clicks ) /
                ( whole_delta_clicks * restrictions.amnesty_price - whole_delta_sum );
        }

        res.total.clicks += segment_part * whole_delta_clicks;
        res.total.shows  += segment_part * whole_delta_shows;
        res.total.sum    += segment_part * whole_delta_sum;
        res.total.amnesty_price     = amnesty_price(res.total.sum, res.total.clicks);

        res.yandex.clicks += segment_part * s.yandex.delta_clicks;
        res.yandex.shows  += segment_part * s.yandex.delta_shows;
        res.yandex.sum    += segment_part * s.yandex.delta_sum;
        res.yandex.amnesty_price     = amnesty_price(res.yandex.sum, res.yandex.clicks);

        var arr_name = "phrases";

        if(! res.yandex[arr_name].hasOwnProperty(phrase_id)){
            res.yandex[arr_name][phrase_id] = {clicks: 0, shows: 0, sum: 0, amnesty_price: 0};
        }

        res.yandex[arr_name][phrase_id].clicks += segment_part * s.yandex.delta_clicks;
        res.yandex[arr_name][phrase_id].shows  += segment_part * s.yandex.delta_shows;
        res.yandex[arr_name][phrase_id].sum    += segment_part * s.yandex.delta_sum;
        res.yandex[arr_name][phrase_id].amnesty_price = amnesty_price(
            res.yandex[arr_name][phrase_id].sum,
            res.yandex[arr_name][phrase_id].clicks);

        if(whole_segment){
            res.yandex[arr_name][phrase_id].position_1 = '';
            res.yandex[arr_name][phrase_id].position_2 = s.next_position;
        } else {
            res.yandex[arr_name][phrase_id].position_1 = res.yandex[arr_name][phrase_id].position_2;
            res.yandex[arr_name][phrase_id].position_2 = s.next_position;
        }

        if(!whole_segment){
            break;
        }

        if (typeof write != 'undefined') write(segment_part + ' * ' + whole_delta_clicks );
    }

    return res;
}

// Из perl'а вызываем только функции с суффиксом _p
function calc_advanced_forecast_p(phrase_data, restrictions, options, currency)
{
    return advanced_forecast_main_loop(phrase_data.data_distributed, restrictions, options, currency);
}

function amnesty_price(sum, clicks)
{
    return clicks > 0 ? (sum / clicks) : 0;
}

