/**
 * Функции для Баблометра, которые исполняются и на стороне js, и на стороне perl
 * в js -- для блока "Управление стратегиями показов"
 * в perl -- для пересчета стратегии в недельный автобюджет
 *
 * Расчет деньги <-> клики для Баблометра, 
 * расчет стратегия -> бюджеты
 */
    
/*
 * TODO
 * Разобраться, можно ли через JavaScript обращаться к объектам. 
 * Если можно, то все функции поместить в один объект -- чтобы не засорять глобальное пространство имен
 *
 */

// На входе -- бюджет, результат -- прогноз кликов
function money2clicks_p(budget, opts, this_transitions) {
    var clicks = 0;
    var ignore_rest_camp = opts && opts.ignore_rest_camp ? 1 : 0;
    for (var i=0, l = this_transitions.length; i < l; i++) {
        var transition = this_transitions[i];
        var transitionCost = transition.cost * transition.add_clicks;
        if (transitionCost < budget) {
            if (!(ignore_rest_camp && transition.rest_camp)) { clicks += transition.add_clicks; }
            budget -= transitionCost;
        } else {
            if (!(ignore_rest_camp && transition.rest_camp)) { clicks += (budget / transition.cost); }
            break;
        }
    };
    return Math.round(clicks);
}

// На входе -- желаемое количество кликов, результат -- рекомендация бюджета
function clicks2money_p(clicks, this_transitions) {
    var budget = 0;
    for (var i=0, l = this_transitions.length; i < l; i++) {
        var transition = this_transitions[i];
        var transitionCost = transition.cost * transition.add_clicks;
        if (transition.add_clicks < clicks) {
            clicks -= transition.add_clicks;
            budget += transitionCost;
        } else {
            budget += Math.floor(transition.cost * clicks);
            break;
        }
    };
    return budget;
}

// На входе -- максимальная цена клика, результат -- рекомендация бюджета
function price2money_p(price, this_transitions) {
    var budget = 0, clicks = 0;
    for (var i=0, l = this_transitions.length; i < l; i++) {
        var transition = this_transitions[i];
        var transitionCost = transition.cost * transition.add_clicks;

        if ( (budget + transitionCost) / ( clicks + transition.add_clicks )  <= price ) {
            clicks += transition.add_clicks;
            budget += transitionCost;
        } else {
            var K = transition.add_clicks / transitionCost; 
            var L = 1 / price;
            budget = ( budget * K - clicks ) / ( K - L );
            break;
        }
    };

    budget = budget > 0 ? Math.floor(budget) : 0;
    return budget;
}


function round_budget(sum)
{
    var digits = Math.floor(Math.log(sum)/Math.log(10)-1);
    var p10 = Math.pow(10, digits);
    var rsum = p10 * Math.round(sum / p10);
    return rsum;
}

function prepare_budgets_by_strategies_p(phrases, convUnitRate, currency) {
    var currObj = get_currency(currency),
        budgetHighSum = 0,
        budgetMiddleSum = 0,
        budgetLowSum = 0,
        budgetMiddle,
        maxBudget = 0,
        transitions = [];

    phrases = phrases.sort(function(a, b) { return a.md5 - b.md5 });

    for (var i = 0, length = phrases.length ; i < length ; i++ ) {
        var phrase = phrases[i];

        transitions = transitions.concat(phrase.transitions);

        budgetHighSum += phrase.exps_high || 0 ;
        budgetMiddleSum += phrase.exps_middle || 0;
        budgetLowSum += phrase.exps_low || 0;

        maxBudget += phrase.max_exps || 0;
    }

    transitions = transitions.sort(function(a, b) { return a.cost - b.cost });

    budgetMiddle = Math.max(
        currObj.MIN_AUTOBUDGET * convUnitRate,
        Math.min(budgetMiddleSum, currObj.MONEYMETER_MAX_MIDDLE_SUM * convUnitRate));

    var middlePriceMin = currObj.MONEYMETER_MIDDLE_PRICE_MIN,
        intervalBegin = currObj.MONEYMETER_TYPICAL_MIDDLE_SUM_INTERVAL_BEGIN,
        intervalEnd = currObj.MONEYMETER_TYPICAL_MIDDLE_SUM_INTERVAL_END,
        clicksMiddle = money2clicks_p(budgetMiddle, {}, transitions),
        clicksHighDesired = Math.round(clicksMiddle * 1.2),
        budgetHighByClicks = clicks2money_p(clicksHighDesired, transitions),
        q = budgetMiddle <= intervalBegin * convUnitRate ?
            0 :
            budgetMiddle >= intervalEnd * convUnitRate ?
                1 :
                (budgetMiddle - intervalBegin * convUnitRate) / (intervalEnd * convUnitRate - intervalBegin * convUnitRate),

        budgetHighByPrice = Math.min(
            budgetMiddle * middlePriceMin,
            price2money_p(Math.min(middlePriceMin * convUnitRate, budgetMiddle / clicksMiddle * 3), transitions)),

        budgetHighRecommended = (1 - q) * budgetHighByPrice + q * budgetHighByClicks;

    if (budgetHighSum <= budgetMiddleSum) budgetHighSum = budgetMiddleSum * 2;

    return {
        budgetMiddle: round_budget(budgetMiddle),
        budgetLow: round_budget(Math.max(clicks2money_p(clicksMiddle / 7, transitions), currObj.MIN_AUTOBUDGET * convUnitRate)),
        budgetHigh: round_budget(Math.max(currObj.MIN_AUTOBUDGET * convUnitRate, Math.min(budgetHighSum, budgetHighRecommended))),
        transitions: transitions,
        maxBudget: maxBudget
    };

}


// Считаем бюджеты для всех стратегий по позициям. 
// Из perl'а вызываем только эту функцию. 
function calc_budgets_by_strategies_p(phrases, convUnitRate, currency) {
    var b = prepare_budgets_by_strategies_p(phrases, convUnitRate, currency);

    return {
        middle: b.budgetMiddle,
        low: b.budgetLow,
        high: b.budgetHigh
    };
}

