/* Проверить форму */
function checkForm(oForm) {
    var isCheckForm = true;
    var aCheckFields = [];
    var isImprovementsValid = true;

    if (aFormErrors && aFormErrors.length > 0) {
        for (var n = 0; n < aFormErrors.length; n++) {
            aCheckFields[n] = checkFormField(oForm[aFormErrors[n].name], aFormErrors[n]);
        }

        for (var n = 0; n < aCheckFields.length; n++) {
            if (!aCheckFields[n]) {
                setErrorFocus(aFormErrors[n].name);
                isCheckForm = false;
                break;
            }
        }

        isImprovementsValid = validateImprovements(oForm.improvement);
    }

    return isCheckForm && isImprovementsValid;
}

/**
 * Проверяет отмечен ли хотя бы один чекбокс.
 *
 * @param {Array} fields improvement поля формы.
 * @return {Boolean} Есть ли отмеченный чекбокс.
 */
function validateImprovements(fields) {
    var isValid = false;

    for (var i = 0; i < fields.length; i++) {
        isValid = $(fields[i]).prop('checked');

        if (isValid) break;
    }

    isValid ?
        hideErrorMessage('improvements') :
        showErrorMessage(
            'improvements',
            iget('Необходимо выбрать цель заявки в разделе "Что бы Вы хотели изменить в Вашей рекламной кампании".'));

    return isValid;
}

/* Проверить поле формы */
// TODO: переделать логику, избавиться от кучи проверок
function checkFormField(oField, oError) {
    var isCheckField = true;
    switch (oError.type) {
        case 'value':
            if (oField.value == oError.value) isCheckField = false;
            break;
        case 'checked':
            if (oField.length) {
                for (var n = 0; n < oField.length; n++) {
                    if (oField[n].checked != oError.value) {
                        isCheckField = true;
                        break;
                    } else {
                        isCheckField = false;
                    }
                }
            } else {
                if (oField.checked == oError.value) isCheckField = false;
            }
            break;
    }
    isCheckField ? hideErrorMessage(oError.name) : showErrorMessage(oError.name, oError.text);
    return isCheckField;
}

/* Установить фокус */
function setErrorFocus(sName) {
    var oErrorDiv = document.getElementById('error_' + sName);
    if (oErrorDiv) {
        var aCoords = getBlockOffset(oErrorDiv);
        self.scrollTo(aCoords[0] - 20, aCoords[1] - 20);
    }
}

/* Получить смещение блока */
function getBlockOffset(oBlock) {
    var iOffsetLeft = 0, iOffsetTop = 0;
    var oParent = oBlock;
    while (oParent) {
        iOffsetLeft += parseInt(oParent.offsetLeft);
        iOffsetTop += parseInt(oParent.offsetTop);
        oParent = oParent.offsetParent;
    }
    return [iOffsetLeft, iOffsetTop];
}

/* Показать сообщение об ошибке */
function showErrorMessage(sName, sText) {
    var oErrorDiv = document.getElementById('error_' + sName);
    if (oErrorDiv && !oErrorDiv.innerHTML) {
        oErrorDiv.innerHTML = '<p class="error">' + sText + '</p>';
    }
}

/* Скрыть сообщение об ошибке */
function hideErrorMessage(sName) {
    var oErrorDiv = document.getElementById('error_' + sName);
    if (oErrorDiv && oErrorDiv.innerHTML) {
        oErrorDiv.innerHTML = '';
    }
}

/* Выделить строку таблицы */
function selectTableRow(oInput) {
    var oTableRow = oInput.parentNode.parentNode;
    if (oTableRow.nodeName == 'TR') {
        unselectAllTableRows(oTableRow);
        addClass(oTableRow, 'select');
    }
}

/* Снять выделение со всех строк таблицы */
function unselectAllTableRows(oTableRow) {
    var oTableBody = oTableRow.parentNode;
    var aTableRows = oTableBody.childNodes;
    for (var n = 0; n < aTableRows.length; n++) {
        if (aTableRows[n].nodeName == 'TR') delClass(aTableRows[n], 'select');
    }
}

/* Проверка на целое число */
function checkInteger(oInput) {
    var sValue = oInput.value;
    sValue = sValue.replace(/[^\d]+/g, "");
    if (oInput.value != sValue) oInput.value = sValue;
}

/* Проверка на имя класса */
function isClass(obj, sClass) {
    return obj && obj.className &&
            new RegExp('(^|\\s+)' + sClass + '(\\s+|$)', '')
                    .test(obj.className);
}

/* Добавить класс */
function addClass(obj, sClass) {
    if (obj != null && !isClass(obj, sClass)) {
        if ((typeof(obj.className) != 'undefined') && (obj.className != '')) {
            if (obj.className.indexOf(sClass) == -1)
                obj.className = obj.className + ' ' + sClass;
        }
        else
            obj.className = sClass;
    }
}

/* Удалить класс */
function delClass(obj, sClass) {
    if (obj != null && isClass(obj, sClass)) {
        obj.className = obj.className
            .replace(new RegExp('\\b' + sClass + '\\b', 'g'), '')
            .replace(/^\s|\s$/, '');
    }
}
