function suggest_table(columns) {
    this.show_col = columns;
}



suggest_table.prototype = new function(){
    this.tableHTML = '';
    this.newPhrases = new Array; 
    this.pict_desc = "&nbsp;&darr;";
    this.pict_asc  = "&nbsp;&uarr;";


    this.showAllPhrases = function(){
        if (this.newPhrases == null || this.newPhrases.length == 0 ) {
            document.getElementById('suggest').innerHTML = "Нет подсказок..."; 
            document.getElementById('bottom_buttons').style.display = 'none';
            document.getElementById('button_more').style.display = 'none';
            return;
        }
        document.getElementById("drawing").style.display = 'block';
        removeOldPhrases();

        this.tableHTML = '<table class="tips">';
        this.tableHTML +='<tr>';
        this.tableHTML += (this.plus_button?'<th></th>':'');
        for (i=0; i<this.show_col.length; i++){
            var title = this.show_col[i].title + (sortCol == this.show_col[i].name? (sortOrder == "desc" ? this.pict_desc : this.pict_asc) : "");
            this.tableHTML += '<th>'+(this.show_col[i].nosort ? title : '<a href="javascript:'+this.object_name+'.resortPhrases(\''+this.show_col[i].name+'\')">'+title+'</a>')+'</th>';
        }

        this.tableHTML += (this.minus_button?'<th></th>':'');

        this.tableHTML +='</tr>';

        for (i in this.newPhrases) {
            if (!this.newPhrases.hasOwnProperty(i)) continue;
            this.showOnePhrase(i);
        }         

        this.tableHTML += "</table>"

            
        // вынести наружу    
        var s = document.getElementById('suggest');
        s.innerHTML = this.tableHTML;

        document.getElementById('bottom_buttons').style.display = 'block';
        document.getElementById('button_more').style.display = '';
        document.getElementById("drawing").style.display = 'none';
    }



    this.showOnePhrase = function(n) {
        var tr_style='style = "color: black"'; 
        var plus_style = 'style="" '
        var minus_style = 'style="" '
        if (this.newPhrases[n].st == "minus") {
            tr_style='style = "color: gray"'; 
            plus_style += 'disabled'
        } else if (this.newPhrases[n].st == "plus") {
            tr_style='style = "color: green"'; 
            plus_style += 'disabled'
            minus_style += 'disabled'
        };  

        this.tableHTML += '<tr '+tr_style+' id="'+n+'" >';
        this.tableHTML += this.plus_button?'<td align="center"><input type=button id= "plus_'+n+'" name="'+n+'" value="+" '+plus_style+ ' onclick="'+this.object_name+'.addPhrase(this.name)" title="Берем!"></td>':'';

        for (i=0; i<this.show_col.length; i++){
            this.tableHTML += '<td>'+this.newPhrases[n][this.show_col[i].name]+'</td>';
        }
        
        this.tableHTML += this.minus_button?'<td align="center"><input type=button id="minus_'+n+'" name="'+n+'" value="&minus;" onclick="'+this.object_name+'.remPhrase(this.name)" title="Не катит!"></td>':'';
        
        this.tableHTML += '</tr>';
    }
    
    
    this.cmpPhrases = function(a,b){
        return sortOrder == "asc" ? a[sortCol] - b[sortCol] : b[sortCol] - a[sortCol];
    }

    this.resortPhrases = function(param){
        sortOrder = (sortCol==param && sortOrder=='desc')?'asc':'desc';
        sortCol = param;
        this.newPhrases.sort(this.cmpPhrases);
        this.showAllPhrases();
        return;
    }

    

    this.addPhrase = function (n){
        newPhrases = newPhrases ? newPhrases + ', ' + this.newPhrases[n].phrase : this.newPhrases[n].phrase;
        opener.BEM.MODEL.get('campaign&banner:' + bid, 'b-banner-edit').set('new_phrases', newPhrases);
        document.getElementById(n).style.color = "green";
        if(this.plus_button)
            document.getElementById("plus_"+n).disabled = 1;
        if(this.minus_button) 
            document.getElementById("minus_"+n).disabled = 1;
        this.newPhrases[n].st = "plus";
    }



    this.remPhrase = function(n){
        if(document.getElementById("plus_"+n).disabled == 0) {
            document.getElementById(n).style.color = "#A9A9A9";//"DarkGray";
            document.getElementById("plus_"+n).disabled = 1;
            this.newPhrases[n].st = "minus";
            unfitPhrases.push(this.newPhrases[n].phrase);
        } else {
            document.getElementById(n).style.color = "black";
            document.getElementById("plus_"+n).disabled = 0;
            this.newPhrases[n].st = "";
            remUnfitPhrase(this.newPhrases[n].phrase);
        }
    }

}


//=========================================================================

var url_suggest_columns = [
    {"name": "phrase", "title": "Фраза", "nosort": 1},
    {"name": "shows", "title": "Показы"},
    {"name": "price", "title": "Средняя цена"},
    {"name": "users_cnt", "title": "Клиенты"}
];
var url_suggest = new suggest_table(url_suggest_columns);
url_suggest.minus_button = 0;
url_suggest.plus_button = 1;
url_suggest.object_name = 'url_suggest';


var phrases_suggest_columns = [
    {"name": "phrase", "title": "Фраза", "nosort": 1},
    {"name": "hits", "title": "Показы"},
    {"name": "price", "title": "Средняя цена"},
    {"name": "users_cnt", "title": "Клиенты"},
    {"name": "rel", "title": "Релевантность"},
    {"name": "dis", "title": "Диссонанс"}
];
var phrases_suggest = new suggest_table(phrases_suggest_columns);
phrases_suggest.minus_button = 1;
phrases_suggest.plus_button = 1;
phrases_suggest.object_name = 'phrases_suggest';


var curSortCol='rel', curSortOrder='desc';

function remUnfitPhrase(str){
    for (i in unfitPhrases) {
        if (!unfitPhrases.hasOwnProperty(i)) continue;
        if (unfitPhrases[i] == str){
            unfitPhrases.splice( i, 1);
        }
    }
}


function removeDissonant(arr){
    if ( arr == null ) {
        return;
    }
    i=0;
    while (i < arr.length) {
        if ( arr[i].dis > arr[i].rel ){
            arr.splice(i, 1); 
        } else {
            i++;
        }
    }
}


function getSuggestion(currency){
    var srcPhrases = opener.BEM.MODEL.get('campaign&banner:' + bid, 'b-banner-edit').get('new_phrases');
    $.getJSON(
        '/registered/main.pl',
        {
            cmd: 'ajaxGetSuggestion',
            srcPhrases: srcPhrases,
            unfitPhrases: unfitPhrases.join(','),
            currency: currency
        },
        function( resp ){

            document.getElementById("loading").style.display = 'none';
            phrases_suggest.newPhrases = resp.phrases;
            sortCol='rel';
            sortOrder='desc';
            removeDissonant(phrases_suggest.newPhrases);
            phrases_suggest.showAllPhrases();
        });
}

// Получить по url список ключевых слов
//todo - перетащить в UrlHandler
function get_url_phrases(url, onready_func, detail ) {
    if (!onready_func) 
        return;
    // Запоминаем URL, отправляемый на проверку
    if (!url.match(/^\s*(http:\/\/)?([a-zа-я0-9-]+\.)+[a-zа-я]+(\s*$|\/|:\d+|\?|#)/i)) {
        return false;
    }
    last_url_phrases = url.replace(/\+/g, '%20');
    if (url.match(/^\s*$/)) return false;
    $.getJSON('/registered/main.pl',  {"cmd": "ajaxGetUrlPhrases", "detail": (detail?'yes':''), "url": url },
        function( resp ){
            if (resp.url != last_url_phrases) return;
            if (resp.code == 1) {
                onready_func(resp.phrases);
                return;
            } else {
                onready_func("");
                return;
            }
        });
}

function getUrlSuggestion(url){
    
    if ( !url){ 
        alert("Empty url");
        return;
    }
    
    document.getElementById("loading").style.display = 'block';
    get_url_phrases(url, processUrlPhrases, 1)
}


function processUrlPhrases(phrases){
    document.getElementById("loading").style.display = 'none';
    url_suggest.newPhrases = phrases;
    sortCol='';
    sortOrder='desc';
    url_suggest.showAllPhrases();
}

function removeOldPhrases() {
    var s = document.getElementById('suggest');
    s.innerHTML = '';
}


function val_draw(val, av_val, max_val, brd, max_width) {
    return '<b class="indicator"><b style="width: '+grad_width(val, av_val, max_val, brd, max_width)+'px;"></b></b> '+val;
}


function grad_width(val, av_val, max_val, brd, max_width) {
    var res;
    if (val > max_val) val = max_val;
    if (val > 0.95*av_val && val < 1.05*av_val) {
        res = brd;
    } else if (val >= av_val) {
        var kk = 1000;
        var k = (100 - brd) / Math.log(1 + (max_val-av_val)/kk);
        res = brd + k * Math.log( 1 + (val-av_val)/kk );
    } else {
        var kk = 10000;
        var k = brd / Math.log(1 + (av_val)/kk);
        res = brd - k * Math.log( 1 + (av_val-val)/kk );
    }
    return Math.floor(max_width*res/100);
}


function saveSuggestedPhrases() {
    window.close();
}


