function SimpleOverlay (geoPoint, name, link) {
    var map, _this = this, offset = new YMaps.Point(-50, -15);

    this.onAddToMap = function (pMap, parentContainer) {
        map = pMap;
        parentContainer.appendChild(getElement());
        this.onMapUpdate();
    };

    this.onRemoveFromMap = function () {
        if (getElement().parentNode) {
            getElement().parentNode.removeChild(getElement());
        }
    };

    this.onMapUpdate = function () {
        var position = map.converter.coordinatesToMapPixels(geoPoint).moveBy(offset);
        getElement().style.left = position.x + 'px';
        getElement().style.top = position.y + 'px';
    };

    this.openBalloon = function () {
        link.className = "active";
        getElement().style.display = "none";
        map.openBalloon(geoPoint, name, {onClose: function () {
            link.className = getElement().style.display = "";
        }});
    };

    function getElement () {
        var element = document.createElement('div');
        element.className = 'overlay';
        element.innerHTML = '<p>Объявление</p>';
        element.onclick = function () {
            _this.openBalloon();
        }
        return (getElement = function () {return element})();
    }
}