<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" lego "
    version="1.0">

<!-- ############################################################################################################## -->

<xsl:output encoding="utf-8" method="xml"/>

<!--

Примеры использования:

    <xsl:call-template name="lego:apply">
        <xsl:with-param name="content">
            <lego:b-button url="/">текст кнопки</lego:b-button>
        </xsl:with-param>
    </xsl:call-template>

    <xsl:call-template name="lego:apply">
        <xsl:with-param name="content">
            <lego:b-button url="/" lego:height="26" lego:background="26-1981d6">текст кнопки</lego:b-button>
        </xsl:with-param>
    </xsl:call-template>


    <xsl:call-template name="lego:apply">
        <xsl:with-param name="content">
            <lego:b-button disabled="" lego:height="26" lego:background="26-1981d6">текст кнопки</lego:b-button>
        </xsl:with-param>
    </xsl:call-template>

-->

<xsl:template match="lego:b-button">
    <xsl:element name="{lego:if(@url, 'a', 'button')}">
        <xsl:apply-templates select="." mode="lego:url"/>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:js-params"/>
        <span class="content">
            <xsl:apply-templates select="@disabled"/>
            <xsl:apply-templates select="." mode="lego:text"/>
        </span>
    </xsl:element>
</xsl:template>

<xsl:template match="lego:b-button" mode="lego:text">
    <b class="text">
        <xsl:apply-templates select="lego:text" mode="lego:style"/>
        <xsl:apply-templates mode="lego:copy"/>
        <i class="l"><i class="c"></i></i><i class="r"><i class="c"></i></i>
        <i class="m"><i class="b"></i></i><i class="s"><i class="b"></i></i>
    </b>
</xsl:template>

<xsl:template match="lego:b-button/lego:text" mode="lego:copy">
    <xsl:apply-templates mode="lego:copy"/>
</xsl:template>

<xsl:template match="lego:b-button/lego:text" mode="lego:style">
    <xsl:attribute name="style">
        <xsl:apply-templates select="@*" mode="lego:style"/>
    </xsl:attribute>
</xsl:template>

<xsl:template match="lego:b-button/lego:text/@*" mode="lego:style">
    <xsl:text> </xsl:text>
    <xsl:value-of select="name()"/>
    <xsl:text>: </xsl:text>
    <xsl:value-of select="."/>
    <xsl:text>;</xsl:text>
</xsl:template>

<xsl:template match="lego:b-button/lego:text/@bold[. = 'yes']" mode="lego:style">
    <xsl:text> font-weight: bold;</xsl:text>
</xsl:template>

<xsl:template match="lego:b-button" mode="lego:block-class-js">
    <xsl:text> g-js</xsl:text>
</xsl:template>

<xsl:template match="lego:b-button/@disabled">
    <xsl:attribute name="class"><xsl:text>content disabled</xsl:text></xsl:attribute>
</xsl:template>

<xsl:template match="lego:b-button[@disabled]" mode="lego:url-content"/>

<!-- ############################################################################################################## -->

</xsl:stylesheet>

