<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lego="https://lego.yandex-team.ru"
    xmlns:date="http://exslt.org/dates-and-times"
    exclude-result-prefixes=" lego date "
    version="1.0">

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-copyright">
    <xsl:variable name="current-year" select="date:year(date:date-time())"/>
    <xsl:variable name="start-year" select="lego:if(@start, @start, $current-year)"/>
    <div>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:text>©&#160;</xsl:text>
        <xsl:value-of select="$start-year"/>
        <xsl:if test="$current-year != $start-year">
            <xsl:value-of select="concat('&#8211;', $current-year)"/>
        </xsl:if>
        <xsl:value-of select="lego:message('b-copyright-ooo', '&#160;&#160;ООО')"/>
        <xsl:text> </xsl:text>
        <xsl:apply-templates select="." mode="lego:text"/>
    </div>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-copyright" mode="lego:text">
    <xsl:value-of select="lego:message('b-copyright-left-quote', '&#171;')"/>
    <a class="b-copyright__link">
        <xsl:apply-templates select="." mode="lego:url"/>
        <xsl:value-of select="lego:message('b-foot-copyright-yandex', 'Яндекс')"/>
    </a>
    <xsl:value-of select="lego:message('b-copyright-right-quote', '&#187;')"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-copyright[lego:text]" mode="lego:text">
    <xsl:apply-templates select="lego:text"/>
</xsl:template>

</xsl:stylesheet>
