/**
 * Создаёт пример блока, основываясь на файлах
 */

var exec = require('child_process').exec,
    lego = new (require('../../tools/lego').Lego)(process.argv[2]),
    util = require('../../tools/util');

var mods = lego.getModsFromFileSys('b-country-flag');
mods.map(function(m){
    m.vals.map(function(val){
        if (val.name == 'all') return;
        util.sha1sum('blocks/b-country-flag/_' + m.name + '/b-country-flag_' + m.name + '_' + val.name + '.png', function (err, sha1) {
            if (err) throw err;
            var freeze_name = util.fixSha1Base64(sha1),
                freeze_url = '//yastatic.net/lego/_/' + freeze_name + '.png',
                css = '/* This file was generated by script. Don\'t edit it here.*/\n' +
                    '.b-country-flag_' + m.name + '_' + val.name + '\n' +
                    '{\n' +
                    '   width: 16px;\n' +
                    '   height: 11px;\n' +
                    '   background: url(' + freeze_url + ') no-repeat;\n' +
                    '}';
            util.writeFile('blocks/b-country-flag/_' + m.name + '/b-country-flag_' + m.name + '_' + val.name + '.css', css);
        });
    });
});
