/**
 * Создаёт пример блока, основываясь на файлах
 */

var exec = require('child_process').exec,
    lego = new (require('../../../tools/lego').Lego)(process.argv[2]),
    util = require('../../../tools/util');

function generateModXml(m, cb) {
    util.Step(
        function () {
            var _this = this;
            m.vals
                .filter(function(val){
                    return val.name != 'all';
                })
                .map(function(val) {
                    generateModValXml(m, val, _this.parallel());
                });
        },
        function (err) {
            var xml = Array.prototype.slice.call(arguments, 1).join('');
            xml += m.name + ' ';
            cb(null, xml);
        }
    );
}

function generateModValXml(m, val, cb) {
    util.sha1sum('blocks/b-country-flag/_' + m.name + '/b-country-flag_' + m.name + '_' + val.name + '.png', function (err, sha1) {
        if (err) return cb(err);
        var freeze_name = util.fixSha1Base64(sha1),
            freeze_url = '//yastatic.net/lego/_/' + freeze_name + '.png',
            xml = '<lego:item>' +
                '<lego:b-ico src="' + freeze_url + '" alt="' + val.title + '"/>' +
                '<lego:text> <xhtml:strong>' + val.title + '</xhtml:strong> ' + freeze_url +'</lego:text>' +
            '</lego:item>';
        cb(null, xml);
    });
};

function generateExampleXml(lego, cb) {
    var example = '<?xml version="1.0" encoding="utf-8"?>\n' +
    '<!-- Это автоматически сгенеренный файл. Не редактируйте его самостоятельно. -->\n' +
    '<lego:page ' +
    'xmlns:lego="https://lego.yandex-team.ru" ' +
    'xmlns:xhtml="http://www.w3.org/1999/xhtml"' +
    '>';
    var mods = lego.getModsFromFileSys('b-country-flag');
    example += '<lego:b-menu lego:layout="vert">';

    util.Step(
        function () {
            var _this = this;
            mods.map(function(m){
                generateModXml(m, _this.parallel());
            });
        },
        function (err) {
            if (err) return cb(err);
            example += Array.prototype.slice.call(arguments, 1).join('');
            example += '</lego:b-menu>';
            example += '</lego:page>';

            cb(null, example);
        }
    );
}

util.writeFile('blocks/b-country-flag/examples/10_auto-country-flag_xml.title.txt', 'Флаги всех стран');
generateExampleXml(lego, function (err, example) {
    if (err) throw err;
    util.writeFile('blocks/b-country-flag/examples/10_auto-country-flag_xml.xml', example);
    exec('tools/prettyxml blocks/b-country-flag/examples/10_auto-country-flag_xml.xml', function (err, stdout, stderr) {
        if (err) throw err;
    });
});

var all_example = '<?xml version="1.0" encoding="utf-8"?>' +
    '<lego:page ' +
    'xmlns:lego="https://lego.yandex-team.ru" ' +
    'xmlns:xhtml="http://www.w3.org/1999/xhtml"' +
    '>' +
        '<lego:b-ico src="../../blocks/b-country-flag/_size-16/b-country-flag_size-16_all.png" alt="Спрайт со всеми флагами"/>' +
    '</lego:page>';
util.writeFile('blocks/b-country-flag/examples/20_auto-country-flag_size-16-sprite_xml.title.txt', 'Спрайт со всеми странами');
util.writeFile('blocks/b-country-flag/examples/20_auto-country-flag_size-16-sprite_xml.xml', all_example);
exec('tools/prettyxml blocks/b-country-flag/examples/20_auto-country-flag_size-16-sprite_xml.xml', function (err, stdout, stderr) {
    if (err) throw err;
});
