<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" x lego "
    version="1.0">

    <xsl:template match="lego:b-domik[not(lego:auth()) and @lego:type = 'bigform']">
        <form>
            <xsl:apply-templates select="." mode="lego:block-attributes"/>
            <xsl:apply-templates select="." mode="lego:form-attributes"/>
            <xsl:apply-templates select="." mode="lego:js-params"/>

            <xsl:apply-templates select="." mode="lego:logo"/>

            <i class="b-domik__roof"></i>

            <table class="b-domik__shadow" cellspacing="0">
            <tr>
                <td class="b-domik__shadow__lt">&#160;</td>
                <td class="b-domik__shadow__t"></td>
                <td class="b-domik__shadow__rt">&#160;</td>
            </tr>
            <tr>
                <td class="b-domik__shadow__l">&#160;</td>
                <td class="b-domik__shadow__m">
                    <xsl:apply-templates select="." mode="lego:content"/>
                </td>
                <td class="b-domik__shadow__r">&#160;</td>
            </tr>
            <tr>
                <td class="b-domik__shadow__lb">&#160;</td>
                <td class="b-domik__shadow__b"></td>
                <td class="b-domik__shadow__rb">&#160;</td>
            </tr>
            </table>
        </form>
    </xsl:template>

    <!-- Для большой формы берём заголовок из raw-файла -->
    <xsl:template match="lego:b-domik/lego:title[@lego:type = 'bigform']" mode="lego:content">
        <xsl:apply-templates/>
    </xsl:template>

    <xsl:template match="lego:b-domik[not(lego:auth()) and @lego:type = 'bigform']" mode="lego:logo">
        <a class="b-link" href="{lego:message('b-domik:bigform-logo-link', 'http://www.yandex.ru')}">
            <img class="b-ico" src="{concat($lego:lego-static-host, lego:message('b-domik:bigform-logo-url', '/blocks/b-domik/_type/b-domik_type_bigform__logo.png'))}" alt="{lego:message('b-domik:bigform-logo-alt', 'Яндекс')}"/>
        </a>
    </xsl:template>

</xsl:stylesheet>

