(function($, Lego) {
Lego.block['b-domik_type_popup'] = function(params) {

    var thisHolder = $(this), popup;

    // навешиваемся на ссылку "войти"
    $('.b-head-userinfo__entry .b-pseudo-link').click(function(e) {
        e.preventDefault();
        setTimeout(function() {
            show();
        }, 0);
    });

    function show(retpath) {
        if(!popup) init();

        if (retpath)
            Lego.params.retpath = retpath;

        var urlParams = '&from=' + Lego.params['passport-msg'] +
            '&retpath=' + encodeURIComponent(Lego.params.retpath);
        thisHolder.attr('action', Lego.params['passport-host'] + '/passport?mode=auth' + urlParams);
        popup.find('.b-domik__register .b-domik__link')
            .attr('href', Lego.params['passport-host'] + '/passport?mode=' +
                (params.regMode || 'register') + urlParams);
        $(document)
             // скрываем по esc
            .bind('keyup.b-domik', function(e) { if(e.keyCode == 27) { hide(); }})
            // скрываем по клику вне попапа
            .bind('click.b-domik', function(e) {
                var target = $(e.target),
                    parents = target.parents().andSelf();

                if(target.is('input[type=button]') || parents.index(popup) == -1 && !parents.is('.b-popupa')) {
                    hide();
                }
            });
        popup
            .show()
            .find('input[name=login]').focus();
        $(document).trigger('show.b-domik_type_popup');
    }

    function hide() {
        $(document).unbind('.b-domik');
        popup.hide();
    }

    function init() { // вспомогательная ф-ия, создающая элемент попапа при первом открытии попапа
        popup = $(
            '<form class="' + thisHolder.attr('class').replace('g-hidden', '') +  '" method="POST">' +
                '<i class="b-domik__roof"></i>' +
                '<table class="b-domik__shadow">' +
                '<tr>' +
                    '<td class="b-domik__shadow__lt">&nbsp;</td>' +
                    '<td class="b-domik__shadow__t"></td>' +
                    '<td class="b-domik__shadow__rt">&nbsp;</td>' +
                '</tr>' +
                '<tr>' +
                    '<td class="b-domik__shadow__l">&nbsp;</td>' +
                    '<td class="b-domik__shadow__m">' +
                        '<div class="b-domik__form">' +
                            '<div class="b-domik__title">' +
                                (params.title || Lego.message('b-domik:title', 'Вход')) +
                            '</div>' +
                            '<div class="b-domik__username">' +
                                '<label for="b-domik_popup-username" class="b-hint-input g-js" onclick="return {name:\'b-hint-input\'}">' +
                                    Lego.message('b-domik:login', 'логин') +
                                '</label>' +
                                '<div class="b-input"><input class="b-input__text" id="b-domik_popup-username" name="login" value="' + thisHolder.find('input[name=login]').val() + '" tabindex="11"/></div>' +
                            '</div>' +
                            '<div class="b-domik__password">' +
                                '<label for="b-domik_popup-password" class="b-hint-input g-js" onclick="return {name:\'b-hint-input\'}">' +
                                    Lego.message('b-domik:password', 'пароль') +
                                '</label>' +
                                '<div class="b-domik__lock"></div>' +
                                '<div class="b-input"><input class="b-input__text" id="b-domik_popup-password" name="passwd" value="' + thisHolder.find('input[name=passwd]').val() + '" type="password" tabindex="11"/></div>' +
                            '</div>' +
                            '<div class="b-domik__permanent">' +
                                '<input class="b-domik__check" id="b-domik_popup-permanent" name="twoweeks" type="checkbox" value="yes" tabindex="11"/>' +
                                '<label for="b-domik_popup-permanent" class="b-domik__permanent-label">' +
                                    Lego.message('b-domik:permanent', 'запомнить меня') +
                                '</label> ' +
                                '<span class="b-domik__help">(<a class="b-domik__link" href="' + Lego.message('b-domik:help-link', 'http://help.yandex.ru/passport/?id=922493') + '" tabindex="12">' +
                                    Lego.message('b-domik:help', 'что&nbsp;это') +
                                '</a>)</span>' +
                            '</div>' +
                            '<div class="b-domik__button">' +
                                '<input class="b-domik__submit" type="submit" value="' +
                                    Lego.message('b-domik:logon', 'Войти') +
                                '" tabindex="11"/>' +
                                '<input class="b-domik__submit" type="button" value="' +
                                    Lego.message('b-domik:cancel', 'Отмена') +
                                '" tabindex="11"/>' +
                            '</div>' +
                            '<div class="b-domik__social" onclick="return { size: 16 }"></div>' +
                            '<div class="b-domik__register">' +
                                '<a class="b-domik__link" href="" tabindex="11">' +
                                    (params.register || Lego.message('b-domik:register', 'Зарегистрироваться')) +
                                '</a>' +
                            '</div>' +
                            '<div class="b-domik__remember">' +
                                '<a class="b-domik__remind" href="' + Lego.params['passport-host'] + '/passport?mode=restore" tabindex="11">' +
                                    Lego.message('b-domik:remember', 'Напомнить пароль') +
                                '</a>' +
                            '</div>' +
                        '</div>' +
                    '</td>' +
                    '<td class="b-domik__shadow__r">&nbsp;</td>' +
                '</tr>' +
                '<tr>' +
                    '<td class="b-domik__shadow__lb">&nbsp;</td>' +
                    '<td class="b-domik__shadow__b"></td>' +
                    '<td class="b-domik__shadow__rb">&nbsp;</td>' +
                '</tr>' +
                '</table>' +
                '<iframe class="b-popup-under" frameborder="0"></iframe>' +
            '</form>').submit(function(e) {
                e.preventDefault();
                thisHolder
                    .find('input[name=login]').val(popup.find('input[name=login]').change().val()).end()
                    .find('input[name=passwd]').val(popup.find('input[name=passwd]').change().val()).end()
                    .find('input[name=twoweeks]').attr('checked', popup.find('input[name=twoweeks]').attr('checked') || false).end()
                    .append('<input type="hidden" name="timestamp" value="' + +new Date + '"/>')
                    .attr('action', Lego.block['b-domik'].isHTTPSSupported?
                        thisHolder.attr('action').replace(/^http:/, 'https:') :
                        thisHolder.attr('action'))
                    .submit();
            });
            if(Lego.block['b-domik']) {
                Lego.block['b-domik'].call(popup);
            }
            $('body').append(popup);
            Lego.blockInit(popup);
    }

    arguments.callee.login = function() { // ф-ия для открытия попапа извне Lego.block['b-domik_type_popup'].login()
        var args = arguments;
        setTimeout(function() {
            show.apply(this, args);
        }, 0);
    };

};

})(jQuery, window.Lego);
