<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" x lego "
    version="1.0">

    <xsl:template match="lego:b-domik[not(lego:auth()) and @lego:type = 'popup']">
        <form>
            <xsl:apply-templates select="." mode="lego:block-attributes"/>
            <xsl:apply-templates select="." mode="lego:form-attributes"/>
            <xsl:apply-templates select="." mode="lego:js-params"/>
            <xsl:apply-templates select="." mode="lego:content"/>
        </form>
    </xsl:template>

    <xsl:template match="lego:b-domik[@lego:type = 'popup']" mode="lego:block-class-js">
        <xsl:text> g-js g-hidden</xsl:text>
    </xsl:template>

    <xsl:template match="lego:b-domik" mode="lego:js-params-content">
        <xsl:apply-imports/>
        <xsl:text>,title:</xsl:text><xsl:value-of select="x:js-quote(lego:title)"/>
        <xsl:apply-templates select="lego:register" mode="lego:js-params-content"/>
    </xsl:template>

    <xsl:template match="lego:b-domik[@lego:type = 'popup']" mode="lego:content">
        <input name="login"/>
        <input name="passwd" type="password"/>
        <input name="twoweeks" type="checkbox" value="yes"/>
    </xsl:template>

</xsl:stylesheet>

