<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:lego="https://lego.yandex-team.ru"
    xmlns:exsl="http://exslt.org/common"
    exclude-result-prefixes=" lego exsl "
    extension-element-prefixes=" exsl "
    >

    <xsl:include href="../b-popupa/b-popupa.convert2xml.xsl"/>

    <xsl:template match="lego:b-domik">
        <lego:declaration>
            <xsl:variable name="decl">
                <lego:b-popupa>
                    <lego:tail/>
                    <lego:content/>
                </lego:b-popupa>
                <lego:i-popup lego:visibility="visible"/>
            </xsl:variable>
            <xsl:apply-templates select="exsl:node-set($decl)"/>
            <lego:b-popupa lego:theme="feffd6">
                <lego:tail/>
                <lego:content/>
            </lego:b-popupa>
            <lego:b-dropdowna>
                <lego:switcher/>
            </lego:b-dropdowna>
            <lego:i-social/>
            <lego:b-pseudo-link lego:is-bem="yes"/>
            <lego:b-spin lego:theme="blue-16"/>
            <lego:b-spin lego:theme="blue-50"/>
            <lego:b-domik>
                <lego:lock lego:visibility="visible"/>
                <lego:social lego:loading="yes"/>
            </lego:b-domik>
        </lego:declaration>
        <xsl:copy>
            <xsl:copy-of select="@*"/>
            <xsl:apply-templates select="." mode="lego:title"/>
            <xsl:apply-templates select="lego:social"/>
            <xsl:apply-templates select="." mode="lego:register"/>
            <lego:username>
                <lego:input name="login" type="text">
                    <lego:hint>
                        <lego:b-hint-input>
                            <xsl:value-of select="$messages[@id = 'b-domik:login']"/>
                        </lego:b-hint-input>
                    </lego:hint>
                </lego:input>
            </lego:username>
            <lego:password>
                <lego:input name="passwd" type="password">
                    <lego:hint>
                        <lego:b-hint-input>
                            <xsl:value-of select="$messages[@id = 'b-domik:password']"/>
                        </lego:b-hint-input>
                    </lego:hint>
                    <lego:lock/>
                </lego:input>
            </lego:password>
            <xsl:if test="@lego:type = 'popup'">
                <lego:b-popup-under/>
            </xsl:if>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="lego:b-domik[not(lego:title/text())]" mode="lego:title">
        <lego:title>
            <xsl:value-of select="$messages[@id = 'b-domik:title']"/>
        </lego:title>
    </xsl:template>

    <xsl:template match="lego:b-domik[lego:title/text()]" mode="lego:title">
        <xsl:copy-of select="lego:title"/>
    </xsl:template>

    <xsl:template match="lego:b-domik[@lego:type = 'bigform']" mode="lego:title">
        <lego:title>
            <xsl:value-of select="lego:service-name()"/>
        </lego:title>
    </xsl:template>

    <xsl:template match="lego:b-domik[@lego:type = 'bigform'][lego:title]" mode="lego:title">
        <xsl:copy-of select="lego:title"/>
    </xsl:template>

    <xsl:template match="lego:b-domik[@lego:type = 'onpage' and not(lego:title)]" mode="lego:title">
        <lego:title>
            <xsl:value-of select="$messages[@id = 'b-domik:title']"/>
        </lego:title>
    </xsl:template>

    <xsl:template match="lego:b-domik" mode="lego:register">
        <lego:register>
            <xsl:value-of select="$messages[@id = 'b-domik:register']"/>
        </lego:register>
    </xsl:template>

    <xsl:template match="lego:b-domik[lego:register]" mode="lego:register">
        <xsl:copy-of select="lego:register"/>
    </xsl:template>

</xsl:stylesheet>
